#
# ns-emulate.tcl
#	defaults for nse [ns with emulation support]
#
if [TclObject is-class Network/Pcap/Live] {
	Network/Pcap/Live set snaplen_ 4096;# bpf snap len
	Network/Pcap/Live set promisc_ false;
	Network/Pcap/Live set timeout_ 0
	Network/Pcap/Live set optimize_ true;# bpf code optimizer
	Network/Pcap/Live set offset_ 0.0; # 

	Network/Pcap/File set offset_ 0.0; # ts for 1st pkt in trace file
}

if [TclObject is-class Scheduler/RealTime] {
	Scheduler/RealTime set maxslop_ 10
}

if [TclObject is-class Agent/Tap] {
	Agent/Tap set maxpkt_ 1600
        Agent/Tap set sport_ 0
        Agent/Tap set dport_ 0
}

if [TclObject is-class Agent/IcmpAgent] {
	Agent/IcmpAgent set ttl_ 254
}



if [TclObject is-class ArpAgent] {

	ArpAgent set cachesize_ 10; # entries in arp cache
	ArpAgent instproc init {} {
		$self next
	}

	ArpAgent instproc config ifname {
		$self instvar net_ myether_ myip_
		set net_ [new Network/Pcap/Live]
		$net_ open readwrite $ifname
		set myether_ [$net_ linkaddr]
		set myip_ [$net_ netaddr]
		$net_ filter "arp and (not ether src $myether_) and \
			(ether dst $myether_ \
			or ether dst ff:ff:ff:ff:ff:ff)"
		$self cmd network $net_
		$self cmd myether $myether_
		$self cmd myip $myip_
	}

	ArpAgent instproc filter-off { } {
		$self instvar net_ myether_ myip_
		$net_ close
	}
}

proc AddEmulationChannel {n1 ip1 n2 ip2 {ifname "xl0"}} {
# add a path for live network packets with to flow from
# real machine ip1 into node n1 and then out n2 to ip2
# and vice versa

    global ns_ node_

    #$ns_ use-scheduler RealTime  ;# moved to ns-lib.tcl

#    set ip1 "128.2.194.160"  ;# ke's laptop, data src
#    set ip2 "128.2.250.51"  ;# farm2 data sink 
#    set ifname "xl0"

    set arpagent [new ArpAgent]
    $arpagent config $ifname
    set myether [$arpagent set myether_]
    $arpagent filter-off

    #### tap and writers for node node1
    set bpf1 [new Network/Pcap/Live];    #	used to read IP info
    #$bpf1 set promisc_ true
    set dev1 [$bpf1 open readonly $ifname]

    set ipnet1 [new Network/IP];	 #	used to write IP pkts
    $ipnet1 open writeonly
    $bpf1 filter "ip and ether dst $myether and ip src $ip1 and ip dst $ip2"
    
    set tapin1 [new Agent/Tap]
    set ipout1 [new Agent/Tap]
    $tapin1 network $bpf1
    $ipout1 network $ipnet1

    ##### tap and writers for node n2
    set bpf2 [new Network/Pcap/Live];    #	used to read IP info
    #$bpf2 set promisc_ true
    set dev2 [$bpf2 open readonly $ifname]

    set ipnet2 [new Network/IP];	 #	used to write IP pkts
    $ipnet2 open writeonly
    $bpf2 filter "ip and ether dst $myether and ip src $ip2 and ip dst $ip1"

    set tapin2 [new Agent/Tap]
    set ipout2 [new Agent/Tap]
    $tapin2 network $bpf2
    $ipout2 network $ipnet2

    #####  Attach the agents to the nodes, and connect the agents
    $ns_ attach-agent $node_($n1) $tapin1
    $ns_ attach-agent $node_($n1) $ipout1

    $ns_ attach-agent $node_($n2) $tapin2
    $ns_ attach-agent $node_($n2) $ipout2

    $ns_ connect $tapin1 $ipout2
    $ns_ connect $tapin2 $ipout1
}
