#!/usr/local/bin/perl

#if ($#ARGV != 2) {
#    print "usage: tr-to-plotable <from node> <to node> <trace file>\n";
#    print "    looks for tcp connection from -> to and outputs segment nums\n";
#    die   "    assumes there is only one such connection\n";
#}

my $input_cp = "sa-base.cp";
my $xfer_size = 20547;   # 20547pkts @ 1460 each => 30MB
my $mac_layer = "Mac/802_11";
my $mac_label = "UNKNOWN";
my $scen = "recon";
my $testport = 36;

if ($mac_layer eq 'Mac/NULL') {
    $mac_label = 'macnull';
} elsif ($mac_layer eq 'Mac/802_11') {
    $mac_label = 'mac802';
}



sub perf {
    print "@_\n";
    system(@_);
}

my $src = 2;
my $dst = 9;

for ($dst = 1; $dst <= 16; $dst++)
{
    next if ($dst == $src);

    print "\n\n Begining for source $src and dst $dst\n\n";

    perf("rm -f conn.cp");
    perf("cp $input_cp conn.cp");

    perf("cmu/scripts/add-ntrwkld.pl conn.cp $src $dst");
    perf("./ns cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl -sc $scen -cp conn.cp -mac $mac_layer");
    perf("grep '^P' out.tr > ntr-test/$scen-$dst-$mac_label-ntrwkld");

    perf("rm -f conn.cp");
    perf("cp $input_cp conn.cp");

    open CPF,">>conn.cp" or die "can't open connection pattern file conn.cp";

    print CPF <<"HERE"
	set testport $testport
	set s_type "TCP/Reno"
	set d_type "TCPSink"
        set pktClass 0
	set source \$node_($src)
	set dest \$node_($dst)

	set s_agent [new Agent/\$s_type]
	set d_agent [new Agent/\$d_type]
	\$s_agent set fid_ \$pktClass
	\$d_agent set fid_ \$pktClass
	\$source attach \$s_agent \$testport
	\$dest attach \$d_agent \$testport
	\$ns_ connect \$s_agent \$d_agent

	set tcp_(test) \$s_agent

	\$tcp_(test) set packetSize_ 1460
	set ftp_(test) [\$tcp_(test) attach-source FTP]
	\$ftp_(test) set  maxpkts_ $xfer_size
	\$ns_ at 0.10 "\$ftp_(test) start"
HERE
;
    close(CPF);

    perf("./ns cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl -sc $scen -cp conn.cp -mac $mac_layer");

    perf("emulate/tr-to-plottable.pl $src $dst $testport out.tr > ntr-test/$scen-$dst-$mac_label.tsp");

    perf("scp ntr-test/$scen-$dst-$mac_label-ntrwkld ares:regression/");
    perf("scp ntr-test/$scen-$dst-$mac_label.tsp ares:regression/");
}
