# hgps.tcl
# ======================================================================
# Default Script Options
# ======================================================================

set opt(rt_port) 255
set opt(cc)      "off"            ;# have god check the caches for bad links?

Agent/CapacityAgent set sport_ 255
Agent/CapacityAgent set dport_ 255

# ======================================================================
Class SRNode -superclass MobileNode

SRNode instproc init {args} {
    global opt ns_ tracefd mytracefd RouterTrace
    $self instvar test_agent_ dmux_ entry_point_

    eval $self next $args	;# parent class constructor

    # puts "making dsragent for node [$self id]"
    set test_agent_ [new Agent/CapacityAgent]

    $test_agent_ ip-addr [$self id]

    $test_agent_ total-nodes $opt(nn)
    $test_agent_ packet-size $opt(pktsize)
    $test_agent_ chain-length $opt(chain)
    $test_agent_ packet-rate $opt(pktrate) 
    $test_agent_ fraction-sending $opt(fracsend)

    $test_agent_ mobile-node $self

    if { $RouterTrace == "ON" } {
	# Recv Target
	set rcvT [cmu-trace Recv "RTR" $self]
	$rcvT target $test_agent_
	set entry_point_ $rcvT	
    } else {
	# Recv Target
	set entry_point_ $test_agent_
    }

    #
    # Drop Target (always on regardless of other tracing)
    #
    set drpT [cmu-trace Drop "RTR" $self]
    $test_agent_ drop-target $drpT

    #
    # Log Target
    #
    set T [new Trace/Generic]
    $T target [$ns_ set nullAgent_]
    $T attach $tracefd
    $T set src_ [$self id]
    $test_agent_ log-target $T

    $test_agent_ target $dmux_

    # packets to the HGPS port should be dropped, since we've
    # already handled them in the DSRAgent at the entry.
    set nullAgent_ [$ns_ set nullAgent_]
    $dmux_ install $opt(rt_port) $nullAgent_

    # SRNodes don't use the IP addr classifier.  The HGPSAgent should
    # be the entry point
    $self instvar classifier_
    set classifier_ "srnode made illegal use of classifier_"

}

SRNode instproc start-hgps {} {
    $self instvar test_agent_ ifq_
    $test_agent_ start
}

SRNode instproc entry {} {
        $self instvar entry_point_
        return $entry_point_
}



SRNode instproc add-interface {args} {
# args are expected to be of the form
# $chan $prop $tracefd $opt(ll) $opt(mac)
    global ns_ opt RouterTrace

    eval $self next $args

    $self instvar test_agent_ mac_ ifq_

    $test_agent_ add-ifq $ifq_(0)

    if { $RouterTrace == "ON" } {
	# Send Target
	set sndT [cmu-trace Send "RTR" $self]
	$sndT target $ifq_(0)
	$test_agent_ add-ll $sndT $mac_(0)
    } else {
	# Send Target
	$test_agent_ add-ll $ifq_(0) $mac_(0)
    }
 
}

SRNode instproc reset args {
    $self instvar test_agent_
    eval $self next $args
    $test_agent_ reset
}

# ======================================================================

proc create-mobile-node { id } {
	global ns_ chan prop topo tracefd opt node_ mytracefd
	global chan prop tracefd topo opt

	set node_($id) [new SRNode]

	set node $node_($id)
	$node random-motion 0		;# disable random motion
	$node topography $topo

        # connect up the channel
        $node add-interface $chan $prop $opt(mac)	\
	     $opt(ifq) $opt(ifqlen) $opt(netif) $opt(ant)

	#
	# This Trace Target is used to log changes in direction
	# and velocity for the mobile node and log actions of the DSR agent
	#
	set T [new Trace/Generic]
	$T target [$ns_ set nullAgent_]
	$T attach $tracefd
	$T set src_ $id
	$node log-target $T

	$ns_ at 0.0 "$node start-hgps"
}

