#!/usr/bin/perl

# usage: combine-drops-by-r.pl <file1> ... <fileN>
# where each file is the output of combine-drops-by-r.pl
# the bins should be the same size on all files

%total_drops = ();

for ($file_index = 0; $file_index < @ARGV; $file_index++) {
    $file = $ARGV[$file_index];
    
    open(F, $file);
    while ($_ = <F>) {
	if (/^#/) {
	    next;
	}
	if (/(\d+)\s+(\d+)/) {
	    $range = $1;
	    $drops = $2;
	    $total_drops{$range} += $drops;
	}
    }
    close F;
}

sub numerically { $a <=> $b; }

foreach $r (sort numerically keys %total_drops) {
    $d = $total_drops{$r};
    print "$r\t$d\n";
}
