#include <stdarg.h>
#include <object.h>
#include <agent.h>
#include <trace.h>
#include <packet.h>
#include <random.h>
#include <cmu/priqueue.h>
#include <cmu/cmu-trace.h>
#include <cmu/mac.h>
#include <cmu/mac-802_11.h>
#include <cmu/god.h>

#define MAX_INDEX 1000
#define MAX_CONN 31

#define ONE_CELL	0
#define CHAIN		1 //the communication pattern is left-to-right
#define GRID		2 //the communication pattern is left-to-right
#define GRID_2		3 //the communication pattern is left-to-right, top-to-bottom
#define RANDOM		4 //random graph, random communication pattern
/* power law traffic pattern:
  pdf[x_, \[Alpha]_, A_, \[Epsilon]_] := x^\[Alpha]/ Integrate[xx^\[Alpha], {xx, \[Epsilon], Sqrt[A]}]
  cdf[x_, \[Alpha]_, A_, \[Epsilon]_] := Integrate[pdf[xx, \[Alpha], A, \[Epsilon]], {xx, \[Epsilon], x}]
*/
#define POWER_NEG2_ALPHA  5 // power law traffic pattern, Alpha = -2
#define POWER_NEG3_ALPHA  6 // power law traffic pattern, Alpha = -3

/* exp traffic pattern:
pdf[x_, \[Alpha]_, A_] := Exp[-x/\[Alpha]]/ Integrate[Exp[-xx/\[Alpha]], {xx, 0, Sqrt[A]}]
cdf[x_, \[Alpha]_, A_] := Integrate[pdf[xx, \[Alpha], A], {xx, 0, x}]
*/
#define EXP_1_ALPHA     7 //

#define EPISILONG	0.5

class RandSendTimer;

class CapacityAgent : public Agent{

    public:
	virtual int command(int argc, const char*const* argv);
	virtual void recv(Packet*, Handler* callback =0);

	void Terminate();
	void Start();
	void sendOnePacket(double);
	void sendOnePacketToDst(double, nsaddr_t);
	void sendPkt();

	void trace(char *fmt, ...);

	void xmitFailed(Packet *pkt);
	void xmitSucceeded(Packet *pkt);

	CapacityAgent();
	~CapacityAgent();

    private:
	Trace *logtarget;
	PriQueue *ifq;

	int off_mac_;
	int off_ll_;
	int off_ip_;

	nsaddr_t myaddr_;
	NsObject *ll;
	Mac802_11      *mac;

	int test_scenario;
	bool i_am_transmitter;
	bool cbr;
	int total_nodes;
	int chain_length;
	int packet_size;
        double packet_rate;
	int total_pkt_sent;
	int total_pkt_length;

        double fraction_sending;
	MobileNode *mynode;

	double maxx,maxy;
	double sqrt_A;
	double x,y,z;

	RandSendTimer *snd_timer;
	friend class RandSendTimer;
	friend void Capacity_XmitFailureCallback(Packet *pkt,void *data);
	friend void Capacity_XmitSuccessCallback(Packet *pkt,void *data);
};

class RandSendTimer : public TimerHandler {
public:
  RandSendTimer(CapacityAgent *a, double period) : TimerHandler(), a_(a), t_(period) { }
  void expire(Event *);

  CapacityAgent *a_;
  double t_;
};    


