#
# Verbal diarrhea...
#
# A Channel defines a physical network.  For example, if you wanted to model
# the behavior of nodes connected to an Ethernet segment, you would define
# a single channel to represent a single Ethernet segment.
#
# Similarly, if you were to designed a WaveLAN network, even with multiple
# cells, you would define a single channel as nodes in neighboring cells can
# interfere with each other.
#
# If, however, you want to model a wireless network, consisting of both
# WaveLAN and satellite hops, you would define (2) channels, one for WaveLAN
# and the other for satellite communication.
#

source cmu/dsr/srnode.tcl

Trace set show_tcphdr_ 1
LL set delay_ 5us
Agent/TCP set packetSize_ 1460

set opt(ifq)		Queue/DropTail
set opt(ifqsize)	50
set opt(prop)		Propagation/FreeSpace
set opt(chan)		Channel
set opt(netif)		NetIf/WaveLAN
set opt(ll)             LL
#set opt(mac)           Mac/802_3
set opt(mac)            Mac/802_11
set opt(tr)		out.tr
set opt(nc)		1		;# Number of Channels
set opt(nn)		3		;# Number of Nodes
set opt(stop)		60.0		;# seconds
set opt(rt_port)        128             ;# must agree with packet.h

Simulator instproc srnode  { chan } {
    global ns_ prop tracefd topo opt
    
    set node [new SRNode]

    $node topography $topo

    $node add-if $chan $prop $tracefd $opt(ll) $opt(mac)

    #
    # This Trace Target is used to log changes in direction
    # and velocity for the mobile node.
    #
    if {$tracefd != ""} {
	set T [new Trace/Generic]
	$T target [$ns_ set nullAgent_]
	$T attach $tracefd
	$T set src_ [$node id]
	$node tracetarget $T
    }
    
    return $node
}

proc getopt {argc argv} {
	global opt
	lappend optlist tr stop num seed tmp
	lappend optlist qsize bw delay ll ifq mac chan tp sink source cbr

	for {set i 0} {$i < $argc} {incr i} {
		set arg [lindex $argv $i]
		if {[string range $arg 0 0] != "-"} continue

		set name [string range $arg 1 end]
		set opt($name) [lindex $argv [expr $i+1]]
	}
}


# *** MAIN PROGRAM ***

if {$argc == 0} {
	puts "Usage: $argv0 \[-stop sec\] \[-nn nodes\] \[-tr tracefile\]\n"
}

getopt $argc $argv

#
# Initialize Global Variables
#
set ns_		[new Simulator]
set prop	[new $opt(prop)]
set tracefd	[open $opt(tr) w]
set topo	[new Topography]

set noroute     [new Trace/Drop]
$noroute target [$ns_ set nullAgent_]
$noroute attach $tracefd
$noroute set src_ 254
$noroute set dst_ 254

#
# The following creates a flat grid that is 1000m X 1000m
#
$topo load_flatgrid 1000 1000

#
# Create the specified number of channels $opt(nc) and their
# corresponding network interfaces.
#
for {set i 0} {$i < $opt(nc) } {incr i} {
	set channel_($i) [new $opt(chan)]
	set iflist_($i) ""		;# interface list for channel $i
}


#
#  Create the specified number of nodes $opt(nn) and "attach" them
#  to channel 0.
#
for {set i 0} {$i < $opt(nn) } {incr i} {
    puts "Making node $i"
    set node($i) [$ns_ srnode $channel_(0)]
#    $ns_ at $i "$node($i) start"
#    $node($i) set position_update_interval_ 5
}

$node(0) set X_ 500
$node(0) set Y_ 0
$node(1) set X_ 500
$node(1) set Y_ 200
$node(2) set X_ 500
$node(2) set Y_ 400

#set dsr [$node(0) set dsr_agent_]
#$ns_ at 0.0 "$dsr testinit"
#set dsr [$node(2) set dsr_agent_]
#$ns_ at 0.0 "$dsr testinit"

set tcp_(0) [$ns_ create-connection \
	TCP $node(0) TCPSink $node(2) 0]
$tcp_(0) set window_ 32

set ftp_(0) [$tcp_(0) attach-source FTP]
$ns_ at 1.0 "$ftp_(0) start"

 
$ns_ at $opt(stop) "$ns_ halt"

$ns_ at 10.0 "$node(1) setdest 999 999 15"

puts "Starting Simulation..."

$ns_ run
