#include <scheduler.h>
#include "neibtab.hh"

int
NeighborTable::share_coordinator(int a_id, int b_id, int ex)
{
  if (a_id == b_id && a_id != ex)
    return a_id;

  Neighbor *a = search_neighbor(a_id);
  Neighbor *b = search_neighbor(b_id);

  if (!a || !b)
    return -1;

  LLIterator *a_c_i = a->coord_iter();
  Coordinator *a_c = (Coordinator*) a_c_i->peek();
  while(a_c) {
    if (a_c->id == ex) {
      a_c = (Coordinator*) a_c_i->next();
      continue;
    }
    if (b->find_coordinator(a_c->id)) {
      delete a_c_i;
      return a_c->id;
    }

    Neighbor *a_c_n = search_neighbor(a_c->id);
    if (a_c_n) {
      LLIterator *a_c_c_i = a_c_n->coord_iter();
      Coordinator *a_c_c = (Coordinator*) a_c_c_i->peek();
      while(a_c_c) {
	if (a_c_c->id == ex) {
	  a_c_c = (Coordinator*) a_c_c_i->next();
	  continue;
	}
	if (b->find_coordinator(a_c_c->id)) {
	  delete a_c_c_i;
          delete a_c_i;
	  return a_c_c->id;
	}
	a_c_c = (Coordinator*) a_c_c_i->next();
      }
      delete a_c_c_i;
    }
    a_c = (Coordinator*) a_c_i->next();
  }
  delete a_c_i;

  LLIterator *b_c_i = b->coord_iter();
  Coordinator *b_c = (Coordinator*) b_c_i->peek();
  while(b_c) {
    if (b_c->id == ex) {
      b_c = (Coordinator*) b_c_i->next();
      continue;
    }
    if (a->find_coordinator(b_c->id)) {
      delete b_c_i;
      return b_c->id;
    }

    Neighbor *b_c_n = search_neighbor(b_c->id);
    if (b_c_n) {
      LLIterator *b_c_c_i = b_c_n->coord_iter();
      Coordinator *b_c_c = (Coordinator*) b_c_c_i->peek();
      while(b_c_c) {
	if (b_c_c->id == ex) {
	  b_c_c = (Coordinator*) b_c_c_i->next();
	  continue;
	}
	if (a->find_coordinator(b_c_c->id)) {
          delete b_c_c_i;
          delete b_c_i;
	  return b_c_c->id;
	}
	b_c_c = (Coordinator*) b_c_c_i->next();
      }
      delete b_c_c_i;
    }
    b_c = (Coordinator*) b_c_i->next();
  }
  delete b_c_i;

  return -1;
}

int
NeighborTable::share_neighbor(int a_id, int b_id, int ex)
{
  if (a_id == b_id && a_id != ex)
    return a_id;

  Neighbor *a = search_neighbor(a_id);
  Neighbor *b = search_neighbor(b_id);

  if (!a || !b)
    return -1;

  for (unsigned i=0; i < a->neighbors.size(); i++) {
    int a_n = a->neighbors[i];
    if (a_n == ex)
      continue;
    if (a_n == b_id && b_id != ex) {
      return a_n;
    }
    for (unsigned j=0; j < b->neighbors.size(); j++) {
      int b_n = b->neighbors[j];
      if (b_n == ex)
	continue;
      if (a_n == b_n) {
	return a_n;
      }

      Neighbor *a_n_n = search_neighbor(a_n);
      if (a_n_n) {
        for (unsigned k=0; k < a_n_n->neighbors.size(); k++)
          if (b_n == a_n_n->neighbors[k]) {
	    return b_n;
	  }
      }
      
      Neighbor *b_n_n = search_neighbor(b_n);
      if (b_n_n) {
        for (unsigned k=0; k < b_n_n->neighbors.size(); k++)
          if (a_n == b_n_n->neighbors[k]) {
	    return a_n;
	  }
      }
    }
  } 
  return -1;
}

void
NeighborTable::expire_old_entries(int myid, int expire)
{
  Scheduler & s = Scheduler::instance();
  double now = s.clock();
  LLIterator *iter = neighbors();
  Neighbor *n = (Neighbor*)iter->peek();
  vector<int> to_remove;
 
  while(n) {
    if (now - n->nounce > expire)
      to_remove.push_back(n->id);
    n = (Neighbor*)iter->next();
  }
  delete iter;

  for(unsigned i=0; i<to_remove.size(); i++) {
    remove_coordinator(myid, to_remove[i]);
    remove_neighbor(to_remove[i]);
  }
}


