/* this file is for setting a percentage of the nodes in the entire network to go to
   sleep simultaneously. Some part of the code is based on dmalz's setdest.cc
   -jinyang */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <assert.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <string.h>
#include <err.h>

#define ROUND_ERROR 1e-9
#define		min(x,y)	((x) < (y) ? (x) : (y))

#define QUERY_START_TIME 50.0   //let location queries start 50s into simulations after all unstable nodes have crashed
#define SIMULATION_TIME 300.0

void
usage(char **argv)
{
   fprintf(stderr, "\nusage: %s\t-n <total nodes> -p <percentage of the sleeping nodes>\n", 
	  argv[0]);
}

double TIME = 0.0;
double MAXTIME = 0.0;
double PERCENTAGE = 0.0;
u_int32_t NODES = 0;
bool *AliveNodeList;

static int count = 0;

/* ======================================================================
   Random Number Generation
   ====================================================================== */
#define M		2147483647L
#define INVERSE_M	((double)4.656612875e-10)

char random_state[32];

double
uniform()
{
   count++;
   return random() * INVERSE_M;
}


void
init()
{
   /*
    * Initialized the Random Number Generation
    */
   struct timeval tp;
   int fd, seed, bytes;
   
   if((fd = open("/dev/random", O_RDONLY)) < 0) {
   	perror("open /dev/random");
   	exit(1);
   }
   if((bytes = read(fd, random_state, sizeof(random_state))) < 0) {
   	perror("read");
   	exit(1);
   }
   close(fd);
   
   fprintf(stderr, "*** read %d bytes from /dev/random\n", bytes);
   
   if(bytes != sizeof(random_state)) {
     fprintf(stderr,"Not enough randomness. Reading `.rand_state'\n");
     if((fd = open(".rand_state", O_RDONLY)) < 0) {
       perror("open .rand_state");
       exit(1);
     }
     if((bytes = read(fd, random_state, sizeof(random_state))) < 0) {
       perror("reading .rand_state");
       exit(1);
     }
     close(fd);
   }
   
   if(gettimeofday(&tp, 0) < 0) {
   	perror("gettimeofday");
   	exit(1);
   }
   seed = (tp.tv_sec  >> 12 ) ^ tp.tv_usec;
   (void) initstate(seed, random_state, bytes & 0xf8);
   
   /*
    * Allocate memory for globals
    */
   AliveNodeList = new bool[NODES];
   if(AliveNodeList == 0) {
   	perror("new");
   	exit(1);
  }

   for (int i=0;i<NODES;i++) {
       AliveNodeList[i] = true;
   }
  
} 
  

int main(int argc, char **argv)
{
    char ch;
    while ((ch = getopt(argc, argv, "n:p:")) != EOF) {       

	switch (ch) { 

	case 'n':
	    NODES = atoi(optarg)+1;
	    break;
	case 'p':
	    PERCENTAGE = atof(optarg);
	    break;
	default:
	    usage(argv);
	    exit(1);

	}
    }
    
    if ((NODES == 0) || (PERCENTAGE == 0.0)) {
	usage(argv);
	exit(1);
    }

    fprintf(stdout, "#\n# nodes: %d, percentage of dead nodes: %f\n", NODES-1,PERCENTAGE);
  
    init();

    int i = 1;
    double uni;
    int dead_nodes = (int)floor(PERCENTAGE * (NODES-1));
    
    while (dead_nodes) {
	uni = uniform();
	if ((uni<PERCENTAGE) && (AliveNodeList[i])) {
	    dead_nodes--;
	    if (dead_nodes == 0) break;
	    //these are stable nodes
	    fprintf(stdout, "$ns_ at %.12f \"$node_(%d) wakeup %.12f\"\n",
			0.0, i, QUERY_START_TIME-5);
    	    fprintf(stdout, "$ns_ at %.12f \"$god_ wakeup %d %.12f\"\n",0.0,i,QUERY_START_TIME - 5);
	    AliveNodeList[i] = false;
	}
	i++;
	if (i>=NODES) {
	    i = 1; //reset;
	}
    }

    for (int i=1;i<NODES;i++) {
	if (AliveNodeList[i]) {
	    //these are stable nodes
	    fprintf(stdout, "$ns_ at %.12f \"$node_(%d) wakeup %.12f\"\n",
			0.0, i, SIMULATION_TIME);
    	    fprintf(stdout, "$ns_ at %.12f \"$god_ wakeup %d %.12f\"\n",0.0,i,SIMULATION_TIME);
	}
    }
}
