#! /usr/bin/tclsh
# $Id: make-vary-density.tcl,v 1.1.1.1 2001/11/15 19:43:20 benjie Exp $

# usage: make-vary-density.tcl  <ns-dir>

# produces directory hierarchy of cbr and scen for varying density but
# constant area scripts with paths in the following format:

# ./cbr/num-nodes/pkts-per-conn/num-conn 
# ./scen/num-nodes/side-len/max-spd

# num-conn is either 3n (each node connects to 3 others) or nn (each
# node connects to every other node)

# traffic is generated to occur between 10 and 400 seconds; the
# `empty' 10 seconds in the beginning allows the routing protocols and
# location service etc. to initialize.



set currdir [exec pwd]

set length 1000
set area [expr $length * $length]

# density is nodes / m^2
set min_density 2.5e-5
set max_density 1e-3
set step_density 2.5e-5 

set nsdir [lindex $argv 0]

set ns "$nsdir/ns"
set cbrgen_nn "$nsdir/cmu/scripts/cbrgen-nn.tcl"
set cbrgen_cn "$nsdir/cmu/scripts/cbrgen-cn.tcl"
set rate 4.0
set c 3

set setdest "$nsdir/cmu/setdest/setdest"

set pkt_lengths { 6 }
set max_speeds { 10 }

	
proc make_cbr_files { n } {
    global currdir
    global pkt_lengths
    if { ! [ file exists "$currdir/cbr" ] } { exec mkdir "$currdir/cbr" }
    if { ! [ file exists "$currdir/cbr/$n" ] } { exec mkdir "$currdir/cbr/$n" }
    foreach num_pkts $pkt_lengths {
	set pkt_dir "$currdir/cbr/$n/$num_pkts"
	if { ! [ file exists $pkt_dir ] } { exec mkdir $pkt_dir }
	global ns
	global cbrgen_nn
	global cbrgen_cn
	global rate
	global c
	exec $ns $cbrgen_nn -type cbr -nn $n -seed env(RANDOM) -rate $rate -numpackets $num_pkts > $pkt_dir/nn
	exec $ns $cbrgen_cn -type cbr -nn $n -seed env(RANDOM) -rate $rate -numpackets $num_pkts -c $c > $pkt_dir/${c}n
    }
}

proc make_scen_files { n length } {
    global currdir
    global max_speeds
    global setdest
    if { ! [ file exists "$currdir/scen" ] } { exec mkdir "$currdir/scen" }
    if { ! [ file exists "$currdir/scen/$n" ] } { exec mkdir "$currdir/scen/$n" }
    if { ! [ file exists "$currdir/scen/$n/$length" ] } { exec mkdir "$currdir/scen/$n/$length" }
    set cbr_dir "$currdir/scen/$n/$length"
    foreach speed $max_speeds {
	catch {
	    exec $setdest -n $n -t 300 -x $length -y $length -p 0 -s $speed > "$cbr_dir/$speed"
	}
    }
}


if { ! [ file exists "scen" ] } { exec mkdir "scen" }
    
for { set target_density $min_density } { $target_density <= $max_density } { set target_density [expr $target_density + $step_density] } {
    puts "target density is $target_density"
    set n [expr $target_density * $area]
    set n [ expr int($n) ]
    make_cbr_files $n 
    make_scen_files $n $length
}
