#! /bin/sh
# $Id: make-scen-files.sh,v 1.1.1.1 2001/11/15 19:43:20 benjie Exp $

# produces directory hierarchy of movement scenario files in the
# following path arrangement:

# ./num-nodes/side-length/speed

# speed is meters per second

# movement is from 0 to 300 seconds

# first argument is the directory holding ns; make sure that you have
# compiled setdetst, it lives in <ns>/cmu/setdest.

scen_dir=`pwd`
echo "working in scen dir $scendir"

ns=$1/ns
setdest=$1/cmu/setdest/setdest


# fill in actual packet/num-conns dirs and cbr files
function make_scen_files () { # dir, n, side length

    dir=$1
    n=$2
    length=$3
    last_dir=$dir/$n/$length

    if [ ! -d $dir/$n ] ; then
	mkdir $dir/$n
    fi
    if [ ! -d $last_dir ] ; then
	mkdir $last_dir
    fi
	
    # make a couple of different scenario files for different speeds
    for speed in 5 10 20 ; do
	$setdest -n $n -t 300 -x $length -y $length -p 0 -s $speed > $last_dir/$speed
    done
}
	

# build scen script hierarchy for n, length

for length in 500 700 800
do
    make_scen_files $scen_dir 50 $length
done

for length in 700 1000 1200
do
    make_scen_files $scen_dir 100 $length
done

for length in 800 1200 1500
do
    make_scen_files $scen_dir 150 $length
done

for length in 1000 1400 1700
do
    make_scen_files $scen_dir 200 $length
done

for length in 1100 1500 1900
do
    make_scen_files $scen_dir 250 $length
done


for length in 1200 1700 2100
do
    make_scen_files $scen_dir 300 $length
done

