#!/usr/bin/perl

# This script is for processing the output of a Grid simulation.  It
# is not general!

%packets = (); # CBR data packets
%lr_packets = (); # routing protocol packets

$max_rt_sz = -1;
$max_geo_rt_sz = -1;
$max_ignorant_rt_sz = -1;

LINE: while(<>) {

    if (/^S \d+.\d+ _(\d+)_ looping pkt (\d+)/) {
	$uid = $2;
	$packets{$uid}->{looped} = 1;
    }
    elsif (/^S \d+.\d+ _(\d+)_ rescuing pkt (\d+)/) {
	$uid = $2;
	$packets{$uid}->{rescued}++;
    }
    elsif (/^S \d+.\d+ _(\d+)_ max rt size (\d+)/) {
	print "fuck\n";
	$max_rt_sz = $2;
    }
    elsif (/^S \d+.\d+ _(\d+)_ max geo rt size (\d+)/) {
	$max_geo_rt_sz = $2;
    }
    elsif (/^S \d+.\d+ _(\d+)_ max ignorant rt size (\d+)/) {
	$max_ignorant_rt_sz = $2;
    }
    elsif (/^([rsfD]) \d+.\d+ _(\d+)_ (\S+)\s+(\S+) (\d+) (\S+) \d+ \[\w+ \w+ \S+ (\w+) \w+\]/o) {
	
	$event = $1;
	$node = $2;
	$agent = $3;
	$uid = $5;  # packet uid
	$type = $6; # packet type
	$src_mac = $7;

	if ($type eq "Grid_LR") {
	    if ($agent eq "RTR") {
		if ($event eq "s") {
		    $lr_packets{$uid}->{rtr_sent}++;
		}
		elsif ($event eq "r") {
		    $lr_packets{$uid}->{rtr_recv}++;
		}
		elsif ($event eq "D") {
		    $lr_packets{$uid}->{rtr_drop}++;
		}
		else {
		    die "RTR had unknown log line type `$event'";
		}
	    }
	    elsif ($agent eq "IFQ") {
		if (!($event eq "D")) { die "IFQ had `$event' line instead of `D' line for Grid_LR packet"; }
		$lr_packets{$uid}->{ifq_drop}++;
	    }
	    else {
		die "unknown agent type for Grid_LR packet, `$agent'";
	    }
	}
	elsif ($type eq "cbr") {
	    next LINE if ($event eq "r" && $agent eq "RTR" && $src_mac == 0); # RTR receives initial packet from higher layer
	    
#	 print "ev: $event\n";
#	 print "node: $node\n";
#	 print "agent: $agent\n";
#	 print "uid: $uid\n";
#	 print "type: $type\n";
#	 print "\n";

	    if ($agent eq "AGT") {
		if (!($event eq "s")) { die "AGT had `$event' line instead of `s' line"; }
		$packets{$uid}->{agent_sent}++;
	    }
	    elsif ($agent eq "RTR") {
		if ($event eq "s") {
		    $packets{$uid}->{rtr_sent}++;
		}
		elsif ($event eq "f") {
		    $packets{$uid}->{rtr_fwd}++;
		}
		elsif ($event eq "r") {
		    $packets{$uid}->{rtr_recv}++;
		}
		elsif ($event eq "D") {
		    $packets{$uid}->{rtr_drop}++;
		}
		else {
		    die "RTR had unknown log line type `$event'";
		}
	    }
	    elsif ($agent eq "IFQ") {
		if (!($event eq "D")) { die "IFQ had `$event' line instead of `D' line for CBR packet"; }
		$packets{$uid}->{ifq_drop}++;
	    }
	    else {
		die "unknown agent type for CBR packet, `$agent'";
	    }	
	}
    }
}

sub numerically { $a <=> $b; }

$rtr_dropped_after_tx = 0;
$rtr_dropped_after_rx = 0;
$rtr_dropped_immediately = 0;
$rtr_dropped = 0;
$ifq_dropped = 0;
$num_looped = 0;
$num_cbr_packets = 0;
$num_rescued = 0;

foreach $uid (sort numerically keys %packets) {
    $num_cbr_packets++;
    $agent_sent = $packets{$uid}->{agent_sent};
    $rtr_sent = $packets{$uid}->{rtr_sent};
    $rtr_fwd = $packets{$uid}->{rtr_fwd};
    $rtr_recv = $packets{$uid}->{rtr_recv};
    $rtr_drop = $packets{$uid}->{rtr_drop};
    $ifq_drop = $packets{$uid}->{ifq_drop};
    $did_loop = $packets{$uid}->{looped};
    $was_rescued = $packets{$uid}->{rescued} > 0;

    # printf "uid: %d, as: %d, rs: %d, rf: %d, rr: %d, rd: %d, id: %d\n", $uid, $agent_sent, $rtr_sent, $rtr_fwd, $rtr_recv, $rtr_drop, $ifq_drop; 

    # if ($agent_sent != 1) {
    # 	  printf "packet %d sent %d times by AGT\n", $uid, $agent_sent;
    # }
    if ($was_rescued) {
	$num_rescued++;
    }
    if  ($did_loop == 1) {
	$num_looped++;
	printf "packet %d looped\n", $uid;
    }
    if ($rtr_sent == 0) {
	# print "packet $uid dropped immediately\n";
	$rtr_dropped_immediately++;
    }
    elsif ($rtr_sent != 1) {
	# ignore this, can get sent more than once if loops through originator
	# printf "packet %d sent %d times by RTR\n", $uid, $rtr_sent;
    }
    if ($rtr_drop > 1) {
	print "packet %d dropped %d times by RTR\n", $uid, $rtr_drop;
    }
    if ($ifq_drop > 1) {
	print "packet %d dropped %d times by IFQ\n", $uid, $ifq_drop;
    }
    if ($ifq_drop > 0 && $rtr_drop > 0) {
	print "packet %d  dropped by both IFQ and RTR\n", $uid;
    }
    if ($ifq_drop == 0 && $rtr_drop == 0) { # no drops
	if ($rtr_recv != ($rtr_sent + $rtr_fwd)) {
# ignore: when rescuing packets, we can send the same
# packet more than once before it is received
	    # printf "packet uid %d (no drop): \n\tRTR-sent %d \n\tRTR-fwd  %d \n\tRTR-recv %d \n\tRTR-drop %d \n\tIFQ-drop %d\n", $uid, $rtr_sent, $rtr_fwd, $rtr_recv, $rtr_drop, $ifq_drop;
	}
    }
    elsif ($rtr_drop == 1 && $ifq_drop == 0) {
	$rtr_dropped++
# ignore, rescuing invalidates this logic
# 	  if (($rtr_sent + $rtr_fwd) == ($rtr_recv + $rtr_drop)) {
# 	      $rtr_dropped_after_tx++;
# 	  }
# 	  elsif (($rtr_sent + $rtr_fwd) == $rtr_recv) {
# 	      $rtr_dropped_after_rx++;
# 	  }
# 	  else {
# 	      printf "packet uid %d (RTR drop): \n\tRTR-sent %d \n\tRTR-fwd  %d \n\tRTR-recv %d \n\tRTR-drop %d \n\tIFQ-drop %d\n", $uid, $rtr_sent, $rtr_fwd, $rtr_recv, $rtr_drop, $ifq_drop;
# 	  }
    }
    elsif ($rtr_drop == 0 &&  $ifq_drop == 1) {
	$ifq_dropped++;
	if (($rtr_sent + $rtr_fwd) != ($rtr_recv + $ifq_drop)) {
	    printf "packet uid %d (IFQ drop): \n\tRTR-sent %d \n\tRTR-fwd  %d \n\tRTR-recv %d \n\tRTR-drop %d \n\tIFQ-drop %d\n", $uid, $rtr_sent, $rtr_fwd, $rtr_recv, $rtr_drop, $ifq_drop;
	}
    }
    else {
	printf "packet uid %d (impossible!): \n\tRTR-sent %d \n\tRTR-fwd  %d \n\tRTR-recv %d \n\tRTR-drop %d \n\tIFQ-drop %d\n", $uid, $rtr_sent, $rtr_fwd, $rtr_recv, $rtr_drop, $ifq_drop;
    }
}

if ($num_cbr_packets == 0) {
    print "Num CBR packets sent == 0!";
    $num_cbr_packets = 1;
}
 
# $pct_total_drops = 100 * ($rtr_dropped_after_tx + $rtr_dropped_after_rx + $ifq_dropped) / $num_cbr_packets;
$pct_total_drops = 100 * ($rtr_dropped + $ifq_dropped) / $num_cbr_packets;
# $pct_tx_dropped = 100 * $rtr_dropped_after_tx / $num_cbr_packets;
# $pct_rx_dropped = 100 * $rtr_dropped_after_rx / $num_cbr_packets;
$pct_immediately_dropped = 100 * $rtr_dropped_immediately / $num_cbr_packets;
$pct_ifq_dropped = 100 * $ifq_dropped / $num_cbr_packets;
$pct_rtr_dropped = 100 * $rtr_dropped / $num_cbr_packets;
$pct_looped = 100 * $num_looped / $num_cbr_packets;
$pct_rescued = 100 * $num_rescued / $num_cbr_packets;

print "       total cbr packets: $num_cbr_packets\n";
# print "    rtr dropped after tx: $rtr_dropped_after_tx ($pct_tx_dropped%)\n";
# print "    rtr dropped after rx: $rtr_dropped_after_rx ($pct_rx_dropped%)\n";
print "(rtr dropped immediately: $rtr_dropped_immediately) ($pct_immediately_dropped%)\n";
print "               rtr drops: $rtr_dropped ($pct_rtr_dropped%)\n";
print "               ifq drops: $ifq_dropped ($pct_ifq_dropped%)\n";
print "             num looping: $num_looped ($pct_looped%)\n";
print "             num rescued: $num_rescued ($pct_rescued%)\n";
print "   total percent dropped: $pct_total_drops%\n";


$lr_rtr_dropped = 0;
$lr_rtr_sent = 0;
$lr_rtr_received = 0;
$lr_ifq_dropped = 0;
$num_lr_packets = 0;

foreach $uid (sort numerically keys %lr_packets) {
    $num_lr_packets++;
    $lr_rtr_sent += $lr_packets{$uid}->{rtr_sent};
    $lr_rtr_received += $lr_packets{$uid}->{rtr_recv};
    $lr_rtr_dropped += $lr_packets{$uid}->{rtr_drop};
    $lr_ifq_dropped += $packets{$uid}->{ifq_drop};
}

if ($num_lr_packets != $lr_rtr_sent) {
    print "Some Grid_LR packets were sent too much or not sent";
}

if ($lr_rtr_sent == 0) {
    print "Num LR packets sent == 0!";
    $lr_rtr_sent = 1;
}
$pct_lr_dropped = 100 * ($lr_rtr_dropped + $lr_ifq_dropped) / $lr_rtr_sent;
$pct_lr_rtr_dropped = 100 * $lr_rtr_dropped / $lr_rtr_sent;
$pct_lr_ifq_dropped = 100 * $lr_ifq_dropped / $lr_rtr_sent;
$lr_total_drops = $lr_rtr_dropped + $lr_ifq_dropped;

# degree is roughly how many nodes received each successful route
# broadcast.  A successfult route message broadcast is one that
# doesn't experience a TX error, nor is it dropped from the ifq.
$avg_degree = $lr_rtr_received / ($lr_rtr_sent - $lr_rtr_dropped - $lr_ifq_dropped);

print "\n";

print "total lr packets sent: $num_lr_packets\n";
print "         lr rtr drops: $lr_rtr_dropped ($pct_lr_rtr_dropped%)\n";
print "         lr ifq drops: $lr_ifq_dropped ($pct_lr_ifq_dropped%)\n";
print "       lr total drops: $lr_total_drops ($pct_lr_dropped%)\n";
print "  lr packets received: $lr_rtr_received\n";
print "        avg lr degree: $avg_degree\n";

print "\n";

print "         max rt size: $max_rt_sz\n";
print "     max geo rt size: $max_geo_rt_sz\n";
print "max ignorant rt size: $max_ignorant_rt_sz\n";

