#!/usr/local/bin/perl

use strict 'vars';
use strict 'subs';

my $MAX_NODES;
my $NODE;
my $code;
my $hdr;
my $line;
my $infile = 0;
my $outfile = 1;
my $check_cache_time = 1.0;

$code->{"add-route"} = 1;
$code->{"notice-route"} = 2;
$code->{"find-route"} = 3;
$code->{"check-cache"} = 4;
$code->{"dead-link"} = 5;
$code->{"evicting-route"} = 6;
$code->{"resurrected-link"} = 7;

$code->{dead} = 0;
$code->{alive} = 1;
$code->{miss} = 2;

# ======================================================================
# Subroutines
# ======================================================================
sub dump_header {
        print "%\n";
        print "% 1: time\n";
        print "% 2: node\n";
        print "% 3: op\n";
        print "%\t $code->{'add-route'} (add-route)\n";
        print "%\t $code->{'notice-route'} (notice-route)\n";
        print "%\t $code->{'find-route'} (find-route)\n";
        print "%\t $code->{'check-cache'} (check-cache)\n";
        print "%\t $code->{'dead-link'} (dead-link)\n";
        print "%\t $code->{'evicting-route'} (evicting-route)\n";
        print "%\t $code->{'resurrected-link'} (resurrected-link)\n";
        print "% 4: status\n";
        print "%\t $code->{dead} (dead)\n";
        print "%\t $code->{alive} (alive)\n";
        print "% 5: length of the path\n";
        print "% 6: index of the bad link\n";
        print "% 7: tested\n";
        print "%\t 1 (tested)\n";
        print "%\t 2 (not tested)\n";
        print "% 8: heard (time information learned)\n";
        print "%\n";
}

sub init_cache_summary {
        my $i;

        for($i = 1; $i <= $MAX_NODES; $i++) {
                $NODE->[$i]->{route_count} = 0;
                $NODE->[$i]->{route_bad_count} = 0;
                $NODE->[$i]->{subroute_count} = 0;
                $NODE->[$i]->{subroute_bad_count} = 0;

                $NODE->[$i]->{link_bad_count} = 0;
                $NODE->[$i]->{link_bad_time} = 0.0;
                $NODE->[$i]->{link_bad_tested} = 0;
                $NODE->[$i]->{link_good_tested} = 0;

                $NODE->[$i]->{route_add_count} = 0;
                $NODE->[$i]->{route_add_bad_count} = 0;
                $NODE->[$i]->{subroute_add_count} = 0;
                $NODE->[$i]->{subroute_add_bad_count} = 0;
                $NODE->[$i]->{link_add_tested} = 0;

                $NODE->[$i]->{route_notice_count} = 0;
                $NODE->[$i]->{route_notice_bad_count} = 0;
                $NODE->[$i]->{subroute_notice_count} = 0;
                $NODE->[$i]->{subroute_notice_bad_count} = 0;
                $NODE->[$i]->{link_notice_tested} = 0;

                $NODE->[$i]->{route_find_count} = 0;
                $NODE->[$i]->{route_find_for_me} = 0;
                $NODE->[$i]->{route_find_bad_count} = 0;
                $NODE->[$i]->{route_find_miss_count} = 0;   
                $NODE->[$i]->{subroute_find_count} = 0;
                $NODE->[$i]->{subroute_find_bad_count} = 0;

#                $NODE->[$i]->{link_bad_tested} = 0;
#                $NODE->[$i]->{link_bad_untested} = 0;

                $NODE->[$i]->{evict_count} = 0;
                $NODE->[$i]->{evict_bad_count} = 0;
                $NODE->[$i]->{link_good_time} = 0;
        }
}


sub dump_cache_summary_header {
        print $outfile "%\n";
        print $outfile "% time node\n";
        print $outfile "%\t 3:  route_count\n";
        print $outfile "%\t 4:  route_bad_count\n";
        print $outfile "%\t 5:  route_count\n";
        print $outfile "%\t 6:  route_bad_count\n";

        print $outfile "%\t 7:  link_bad_count\n";
        print $outfile "%\t 8:  link_bad_time\n";
        print $outfile "%\t 9:  link_bad_tested\n";
        print $outfile "%\t 10: link_good_tested\n";

#        print $outfile "%\t 9: link_bad_tested\n";
#        print $outfile "%\t 10: link_bad_untested\n";

        print $outfile "%\t 11: route_add_count\n";
        print $outfile "%\t 12: route_add_bad_count\n";
        print $outfile "%\t 13: subroute_add_count\n";
        print $outfile "%\t 14: subroute_add_bad_count\n";
        print $outfile "%\t 15: link_add_tested\n";

        print $outfile "%\t 16: route_notice_count\n";
        print $outfile "%\t 17: route_notice_bad_count\n";
        print $outfile "%\t 18: subroute_notice_count\n";
        print $outfile "%\t 19: subroute_notice_bad_count\n";
        print $outfile "%\t 20: link_notice_tested\n";

        print $outfile "%\t 21: route_find_count\n";
        print $outfile "%\t 22: route_find_for_me\n";
        print $outfile "%\t 23: route_find_bad_count\n";
        print $outfile "%\t 24: route_find_miss_count\n";
        print $outfile "%\t 25: subroute_find_count\n";
        print $outfile "%\t 26: subroute_find_bad_count\n";

        print $outfile "%\t 27: evict_count\n";
        print $outfile "%\t 28: evict_bad_count\n";

        print $outfile "%\t 29: link_good_time\n";
        print $outfile "%\n";
}

sub dump_cache_summary {
        my $time = shift(@_);
        my $i;

        for($i = 1; $i <= $MAX_NODES; $i++) {
                printf($outfile "%s %2d %3d %3d %3d %3d ",
                       $time, $i,

                       $NODE->[$i]->{route_count},
                       $NODE->[$i]->{route_bad_count},
                       $NODE->[$i]->{subroute_count},
                       $NODE->[$i]->{subroute_bad_count});

                printf($outfile " %3d %3d %3d %3d ",
                       $NODE->[$i]->{link_bad_count},
                       $NODE->[$i]->{link_bad_time},
                       $NODE->[$i]->{link_bad_tested},
                       $NODE->[$i]->{link_good_tested});

                printf($outfile " %3d %3d %3d %3d %3d ",
                       $NODE->[$i]->{route_add_count},
                       $NODE->[$i]->{route_add_bad_count},
                       $NODE->[$i]->{subroute_add_count},
                       $NODE->[$i]->{subroute_add_bad_count},
                       $NODE->[$i]->{link_add_tested});

                printf($outfile " %3d %3d %3d %3d %3d ",
                       $NODE->[$i]->{route_notice_count},
                       $NODE->[$i]->{route_notice_bad_count},
                       $NODE->[$i]->{subroute_notice_count},
                       $NODE->[$i]->{subroute_notice_bad_count},
                       $NODE->[$i]->{link_notice_tested});

                printf($outfile " %3d %3d %3d %3d %3d %3d ",
                       $NODE->[$i]->{route_find_count},
                       $NODE->[$i]->{route_find_for_me},
                       $NODE->[$i]->{route_find_bad_count},
                       $NODE->[$i]->{route_find_miss_count},   
                       $NODE->[$i]->{subroute_find_count},
                       $NODE->[$i]->{subroute_find_bad_count});

                printf($outfile " %3d %3d",
                       $NODE->[$i]->{evict_count},
                       $NODE->[$i]->{evict_bad_count});

		printf($outfile " %s",
                       $NODE->[$i]->{link_good_time});

		printf($outfile "\n");
        }
}

###########################################################################

#sub update_check_cache {
#        my $node = shift(@_);
#        my $tested = shift(@_);

#        if($tested == 1) {
#                $NODE->[$node]->{link_bad_tested} += 1;
#        } elsif($tested == 2) {
#                $NODE->[$node]->{link_bad_untested} += 1;
#        } else {
#                print stderr "Invalid `tested` value\n";
#                exit 1;
#        }
#}


# ======================================================================
# Main Procedure
# ======================================================================

if($#ARGV != 1) {
	print stderr "\nusage: $0 <input file> <num nodes>\n\n";
	exit 1;
}

if(! open $infile, $ARGV[0]) {
	print stderr "Could not open $ARGV[0]\n";
	exit 1;
}

if(! open $outfile, ">__tmpfile") {
	print stderr "Could not open $ARGV[0]\n";
	exit 1;
}

$MAX_NODES = $ARGV[1];

init_cache_summary();
dump_cache_summary_header();
dump_header();

while(<$infile>) {

	$line += 1;

        if(/^SRC ([0-9.]+) _(\d+)_/o) {
                $hdr->{time} = $1;
                $hdr->{node} = $2;

		if($hdr->{node} > $MAX_NODES) {
			print stderr "Invalid node number $hdr->{node}\n";
			print stderr "$_";
			exit 1;
		}
        }
        else {
                next;   # don't care about this line
        }

        #
        # Dump information each second
        #
        if($hdr->{time} > $check_cache_time) {
                dump_cache_summary($check_cache_time);
                init_cache_summary();
                $check_cache_time += 1.0;     # XXX
        }

	if(/(add-route|notice-route|find-route|dead-link|check-cache|evicting-route|resurrected-link) \[(\d+) (\d+)\] .* dead (\d+) ([0-9.]+)/o) {

                printf("%s %3d %2d %2d %2d %2d %2d %s\n",
                       $hdr->{time},
                       $hdr->{node},
                       $code->{$1},
                       $code->{dead},
                       $2,              # length
                       $3,              # index of bad link
                       $4,              # tested / not tested
                       $5);             # time heard
	}

        elsif(/cache-summary (\d+) (\d+) (\d+) (\d+) \| (\d+) ([0-9.]+) (\d+) (\d+) \| (\d+) (\d+) (\d+) (\d+) (\d+) \| (\d+) (\d+) (\d+) (\d+) (\d+) \| (\d+) (\d+) (\d+) (\d+) (\d+) (\d+) ([Na\d.]+)/o) {
                $NODE->[$hdr->{node}]->{route_count} = $1;
                $NODE->[$hdr->{node}]->{route_bad_count} = $2;
                $NODE->[$hdr->{node}]->{subroute_count} = $3;
                $NODE->[$hdr->{node}]->{subroute_bad_count} = $4;

                $NODE->[$hdr->{node}]->{link_bad_count} = $5;
                $NODE->[$hdr->{node}]->{link_bad_time} = $6;
                $NODE->[$hdr->{node}]->{link_bad_tested} = $7;
                $NODE->[$hdr->{node}]->{link_good_tested} = $8;

                $NODE->[$hdr->{node}]->{route_add_count} = $9;
                $NODE->[$hdr->{node}]->{route_add_bad_count} = $10;
                $NODE->[$hdr->{node}]->{subroute_add_count} = $11;
                $NODE->[$hdr->{node}]->{subroute_add_bad_count} = $12;
                $NODE->[$hdr->{node}]->{link_add_tested} = $13;
                
                $NODE->[$hdr->{node}]->{route_notice_count} = $14;
                $NODE->[$hdr->{node}]->{route_notice_bad_count} = $15;
                $NODE->[$hdr->{node}]->{subroute_notice_count} = $16;
                $NODE->[$hdr->{node}]->{subroute_notice_bad_count} = $17;
                $NODE->[$hdr->{node}]->{link_notice_tested} = $18;

                $NODE->[$hdr->{node}]->{route_find_count} = $19;
                $NODE->[$hdr->{node}]->{route_find_for_me} = $20;
                $NODE->[$hdr->{node}]->{route_find_bad_count} = $21;
                $NODE->[$hdr->{node}]->{route_find_miss_count} = $22;   
                $NODE->[$hdr->{node}]->{subroute_find_count} = $23;
                $NODE->[$hdr->{node}]->{subroute_find_bad_count} = $24;

                $NODE->[$hdr->{node}]->{link_good_time} = $25;
        }
        elsif(/evicting (\d+) (\d+)/o) {
                $NODE->[$hdr->{node}]->{evict_count} += $1;
                $NODE->[$hdr->{node}]->{evict_bad_count} += $2;
        }
#	elsif(/evicting-route.*/o) {
                # ignore for now
#        }
        elsif(/(add-route|notice-route|dead-link|find-route) .* alive/o) {
                # ignore for now
        }
        elsif(/find-route .* miss/o) {
                # ignore
        }
        elsif(/(dump-link|dijkstra)/o) {
                # ignore
        }
        else {
                print stderr "Invalid logging entry\n";
                print stderr $_;
                exit 1;
	}
}

dump_cache_summary($check_cache_time);
