/* -*- c++ -*- 
   propagation.h
   $Id: propagation.h,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $

   superclass of all propagation models
*/
#ifndef __propagation_h__
#define __propagation_h__

#define SPEED_OF_LIGHT	300000000		// 3 * 10^8 m/s
#define PI		3.1415926535897

#include <cmu/topography.h>

#include <cmu/net-if.h>
#include <cmu/sharedmedia.h>

/* ======================================================================
   Progpagation Models

	Using postion and wireless transmission interface properties,
	propagation models compute the power with which a given
	packet will be received.

	Not all propagation models will be implemented for all interface
	types, since a propagation model may only be appropriate for
	certain types of interfaces.

   ====================================================================== */

class Propagation : public TclObject {

public:
  Propagation() : name(NULL), topo(NULL) {}

  // calculate the Pr by which the receiver will get a packet sent by
  // the node that applied the tx PacketStamp for a given inteface 
  // type
  virtual double Pr(PacketStamp *tx, PacketStamp *rx, NetIf *);
  virtual double Pr(PacketStamp *tx, PacketStamp *rx, SharedMedia *);

  virtual int command(int argc, const char*const* argv);
  
protected:
  char *name;
  Topography *topo;
};

#endif /* __propagation_h__ */

