/* 
   propagation.cc
   $Id: propagation.cc,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $
   */

#include <stdio.h>

#include <cmu/topography.h>
#include <cmu/net-if.h>
#include <cmu/sharedmedia.h>
#include <cmu/propagation.h>

int
Propagation::command(int argc, const char*const* argv)
{
  TclObject *obj;  

  if(argc == 3) 
    {
      if( (obj = TclObject::lookup(argv[2])) == 0) 
	{
	  fprintf(stderr, "Propagation: %s lookup of %s failed\n", argv[1],
		  argv[2]);
	  return TCL_ERROR;
	}

      if (strcasecmp(argv[1], "topography") == 0) 
	{
	  topo = (Topography*) obj;
	  return TCL_OK;
	}
    }
  return TclObject::command(argc,argv);
}
 

/* As new network-intefaces are added, add a default method here */

double
Propagation::Pr(PacketStamp *, PacketStamp *, NetIf *)
{
  fprintf(stderr,"Propagation model %s not implemented for generic NetIF\n",
	  name);
  abort();
}


double
Propagation::Pr(PacketStamp *, PacketStamp *, SharedMedia *)
{
  fprintf(stderr,
	  "Propagation model %s not implemented for SharedMedia interface\n",
	  name);
  abort();
}
