/* -*- c++ -*-
   priqueue.h
   
   A simple priority queue with a remove packet function
   $Id: priqueue.h,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $
   */
#ifndef __priqueue_h__
#define __priqueue_h__

#include <object.h>
#include <queue.h>
#include <drop-tail.h>
#include <packet.h>
#include <cmu/list.h>

/* ======================================================================
   The BSD Interface Queues
   ====================================================================== */
struct  ifqueue {
        Packet	*ifq_head;
        Packet	*ifq_tail;
        int     ifq_len;
        int     ifq_maxlen;
        int     ifq_drops;
};
#define IFQ_MAXLEN	50

#define IF_QFULL(ifq)           ((ifq)->ifq_len >= (ifq)->ifq_maxlen)
#define IF_DROP(ifq)            ((ifq)->ifq_drops++)
#define IF_ENQUEUE(ifq, p) {			                \
        (p)->next_ = 0;				                \
        if ((ifq)->ifq_tail == 0)		                \
                (ifq)->ifq_head = p;		                \
        else					                \
                (ifq)->ifq_tail->next_ = (p);	                \
        (ifq)->ifq_tail = (p);			                \
        (ifq)->ifq_len++;			                \
}
#define IF_DEQUEUE(ifq, p) {					\
        (p) = (ifq)->ifq_head;					\
        if (p) {						\
                if (((ifq)->ifq_head = (p)->next_) == 0)	\
                        (ifq)->ifq_tail = 0;			\
                (p)->next_ = 0;					\
                (ifq)->ifq_len--;				\
        }							\
}


/*
 * Control type and number of queues in PriQueue structure.
 */
#define IFQ_RTPROTO	0	/* Routing Protocol Traffic */
#define IFQ_REALTIME	1
#define IFQ_LOWDELAY	2
#define IFQ_NORMAL	3
#define IFQ_MAX		4

typedef int (*PacketFilter)(Packet *, void *);

class PriQueue;

LIST_HEAD(PriQueue_List, PriQueue);

/* ======================================================================
   Handles callbacks for Priority Queues
   ====================================================================== */
class PriQueueHandler : public Handler {
public:
        inline PriQueueHandler(PriQueue *ifq) : qh_ifq(ifq) {}
        void handle(Event*);
private: 
	PriQueue *qh_ifq;
};

/* ======================================================================
   Priority Queues
   ====================================================================== */
class PriQueue : public Connector {
public:
        PriQueue();

        int     command(int argc, const char*const* argv);
	/* called by upper layers to enque the packet */
        void    recv(Packet *p, Handler*);
	/* called by lower layers to get the next packet */
	void	prq_resume(void);


	void	Terminate(void);	/* called at end of simulation */

        void	prq_purge_filter(PacketFilter filter, void * data);
        Packet* prq_get_nexthop(nsaddr_t id);
	int	prq_length(void);

	//added by jinyang
	void    clear();
private:
	int	prq_assign_queue(Packet *p);
	void	prq_enqueue(Packet *p);
	Packet*	prq_dequeue(void);
	void	prq_validate(void);

	struct ifqueue	prq_snd[IFQ_MAX];
	nsaddr_t	prq_ipaddr;	/* IP Address of this machine */
	Trace*		prq_logtarget;	/* Used for logging */
	int		prq_blocked;
	PriQueueHandler	prq_qh;
	
public:
	/*
	 * A global list of Interface Queues.  I use this list to iterate
	 * over all of the queues at the end of the simulation and flush
	 * their contents. - josh
	 */
	LIST_ENTRY(PriQueue) prq_link;
	static struct PriQueue_List prq_head;
};

#endif /* __priqueue_h__ */
