#ifndef mac_null_
#define mac_null_

// stolen from mac-802_11.h since I don't have ml's cmu-trace that groks
// other than 802.11 headers -dam 4/12/99
struct hdr_macnull {
	struct frame_control	dh_fc;
	u_int16_t		dh_duration;
	u_char			dh_da[ETHER_ADDR_LEN];
	u_char			dh_sa[ETHER_ADDR_LEN];
	u_char			dh_bssid[ETHER_ADDR_LEN];
	u_int16_t		dh_scontrol;
	u_char			dh_body[0];
};


class MacNULL;

class MacNULLTimer : public Handler {
public:
	MacNULLTimer(MacNULL* m) :  mac_(m), busy_(0) {}
	virtual void handle(Event *e) = 0; 
	virtual inline void cancel() {
		assert(0);
	}
	virtual void schedule(double t, Packet *p);
	inline int busy(void) { return busy_; }
	inline double expire(void) { return intr.time_; }
protected:
	MacNULL	        *mac_;
	Event		intr;
	int		busy_;
};

class MacNULLSend : public MacNULLTimer {
public:
	MacNULLSend(MacNULL* m) :  MacNULLTimer(m) {}
	virtual void handle(Event *e); 
};

class MacNULLRecv : public MacNULLTimer {
public:
	MacNULLRecv(MacNULL* m) :  MacNULLTimer(m) {}
	virtual void handle(Event *e); 
	virtual void schedule(double t, Packet *p);
};

class MacNULL : public Mac {
	friend MacNULLSend;
	friend MacNULLRecv;
public:
	MacNULL();
	void		recv(Packet *p, Handler *h);
	inline MacAddr	hdr_dst(void* hdr, MacAddr dst = 0);
	inline MacAddr	hdr_src(void* hdr, MacAddr src = 0);
	inline int	hdr_type(void* hdr, u_int16_t type = 0);

private:
	int		command(int argc, const char*const* argv);
	void		discard(Packet *p, const char* why);
	void	        send(Packet *p, Handler *h);

	MacNULLSend     send_timer_;
	MacNULLRecv     recv_timer_;
	void            sendComplete(Packet *p);
	void            recvComplete(Packet *p);
	Handler         *upcall_;
	int             no_delay_send_; // if true, packets can be sent back-to-back

	/*
	 * Debugging Functions.
	 */
	void		trace_pkt(Packet *p);
	void		dump(char* fname);

	inline int initialized() {
		return (logtarget_ && Mac::initialized());
	}

	void mac_log(Packet *p) {
		logtarget_->recv(p, (Handler*) 0);
	}

private:
	int off_arp_;

	/* ============================================================
	   Internal MAC State
	   ============================================================ */

	int		min_frame_len;
#if 0
	NsObject*	logtarget_;
#endif // commented out by jinyang, i believe this is not needed, there's logtarget_ in Mac
	/* ============================================================
	   Duplicate Detection state
	   ============================================================ */
	u_int16_t	sta_seqno;	// next seqno that I'll use
	int		cache_node_count;
};
	
static class MacNULLClass : public TclClass {
public:
	MacNULLClass() : TclClass("Mac/NULL") {}
	TclObject* create(int, const char*const*) {
		return (new MacNULL);
	}
} class_macNULL;

#endif
