/* -*- c++ -*-
   god.cc

   General Operations Director

   perform operations requiring omnipotence in the simulation

   NOTE: Tcl node indexs are 0 based, NS C++ node IP addresses (and the
   node->index() are 1 based.

   $Id: god.cc,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $
   */

#include <object.h>
#include <packet.h>
#include <ip.h>

#include <god.h>
#include <cmu/mac.h>
#include <cmu/mac-802_11.h>

#define RANGE 250.0
#define BIGGEST_MASK 32
#define MAX_Q_LEN 100

#define WHITE 0
#define GREY 1
#define BLACK 2

#define min(x,y)	((x)<(y) ? (x):(y))

#define TX(mac)	((mac->tx_active)?(true):(false))
#define TX_TIMEOUT(mac)	((mac->tx_state!=MAC_IDLE)?(true):(false))
#define RX(mac)	((mac->rx_state != MAC_IDLE)?(true):(false))
#define BACKOFF(mac)	((mac->mhBackoff.busy() && (!mac->mhBackoff.paused()))?(true):(false))
#define USELESS_BACKOFF(mac,nextmac)	(((mac->mhBackoff).busy() && mac->is_idle() && nextmac->i_am_idle())?(true):(false))
#define DEFERING(mac)	((mac->mhDefer.busy() || (!mac->is_idle()))?(true):(false))
#define IDLE(mac)	((!mac->pktTx)?(true):(false))
#define TRUE_IDLE(mac,nextmac)  (((!mac->pktTx)&&mac->is_idle()&&nextmac->i_am_idle())?(true):(false))

#define MAC_SLOTTIME 0.000020

God* God::instance_;

void
GodTimer::handle(Event *e) {

    god_->handleTimer();
    Scheduler::instance().schedule(this,e,interrupt_time_);
}

static class GodClass : public TclClass {
public:
        GodClass() : TclClass("God") {}
        TclObject* create(int, const char*const*) {
                return (new God);
        }
} class_God;


God::God()
{
        min_hops = 0;
        num_nodes = 0;

	//added by Jinyang
	shortest_path = NULL;

	loc_to_nodes = NULL;

	god_timer = new GodTimer(this,MAC_SLOTTIME);

}

void
God::start_maclog()
{
    Scheduler::instance().schedule(god_timer,&god_interrupt_event,MAC_SLOTTIME);
}

void
God::handleTimer()
{
	Mac802_11 *mac;
	Mac802_11 *nextmac;

	for (int i=1;i<num_nodes-1;i++) {
	   mac= (Mac802_11 *)maclist[i];
	   nextmac = (Mac802_11 *)maclist[i+1];
	   if (TX(mac)) {
	       assert(!BACKOFF(mac));

	       maclog[i].tx += MAC_SLOTTIME;

	    }else if (RX(mac)) {
	       assert(!TX(mac));
	       assert(!BACKOFF(mac));
	       maclog[i].rx += MAC_SLOTTIME;

	     }else if (IDLE(mac)){
	       assert(!TX(mac));
	       maclog[i].idle += MAC_SLOTTIME;
	       if (TRUE_IDLE(mac,nextmac)) {
		   maclog[i].true_idle += MAC_SLOTTIME;
	       }

	    }else if (TX_TIMEOUT(mac)){
		assert(!BACKOFF(mac));

		maclog[i].tx += MAC_SLOTTIME;
	    }else if (BACKOFF(mac)) {
	       assert(!TX(mac));
	       assert(!IDLE(mac));
	       assert(!RX(mac));

	       maclog[i].backoff += MAC_SLOTTIME;
	       if (USELESS_BACKOFF(mac,nextmac)) {
		   maclog[i].useless_backoff += MAC_SLOTTIME;
		}
	    } else if (DEFERING(mac)) {
	       assert(!TX(mac));
	       assert(!BACKOFF(mac));
	       assert(!RX(mac));

	       maclog[i].defering += MAC_SLOTTIME;


	    }else{
		abort();
	    }

	}

}
int
God::hops(int i, int j)
{
        return min_hops[i * num_nodes + j];
}


void
God::stampPacket(Packet *p)
{
        hdr_cmn *ch = HDR_CMN(p);
        struct hdr_ip *ih = HDR_IP(p);
        nsaddr_t src = ih->src();
        nsaddr_t dst = ih->dst();

        assert(min_hops);

        if (!DATA_PACKET(ch->ptype())) return;

        if (dst > num_nodes || src > num_nodes) return; // broadcast pkt
   
        ch->opt_num_forwards() = min_hops[src * num_nodes + dst];
}

void 
God::recv(Packet *, Handler *)
{
    abort();
}

nsaddr_t
God::getNodeDstAway(double xx, double yy, double dist_away)
{
    /*
#define BUCKET_LEN 100
    if (!dist_to_nodes) {
	//
	for (int i) {
	}
    }

    return good_node;
    */
    return 0;
}

/* added by Jinyang -- only suitable for STATIC network!*/
int
God::shortestPathLength(nsaddr_t src,nsaddr_t dst)
{
    assert(shortest_path);
    int dist = shortest_path[src*num_nodes+dst].dist;
    assert(dist!=0);
    return dist;
}

nsaddr_t
God::shortestPathNextHop(nsaddr_t src,nsaddr_t dst)
{
    nsaddr_t next_hop;

    if (!shortest_path) {

	//allocate space for shortest_path matrix
	shortest_path = new bf_rt_entry[num_nodes*num_nodes];
	memset((bf_rt_entry *)shortest_path,0,num_nodes*num_nodes*sizeof(bf_rt_entry));
    
	//floyd-warshall algo.  
	for (int i = 1;i< num_nodes; i++) {
	    for (int j=1;j< num_nodes; j++) {
		if ( i == j) {
		    shortest_path[i*num_nodes + j].prev_hop = i;
		    shortest_path[i*num_nodes + j].dist = 0;
		}else if ( isNeighbor(i,j)) {
			shortest_path[i*num_nodes + j].prev_hop= i;
			shortest_path[i*num_nodes + j].dist = 1;
		    }else{
			shortest_path[i*num_nodes + j].prev_hop = 0;
			shortest_path[i*num_nodes + j].dist = num_nodes+1;
		    }
		}
	    }
	
	    int new_dist;
	    for (int k=1;k<num_nodes;k++) {
	       for (int i=1;i<num_nodes;i++) {
		   for (int j=1;j<num_nodes;j++) {
		       new_dist = shortest_path[i*num_nodes+k].dist+shortest_path[k*num_nodes+j].dist;
		       if (new_dist < shortest_path[i*num_nodes+j].dist) {
			   shortest_path[i*num_nodes+j].dist = new_dist;
			   shortest_path[i*num_nodes+j].prev_hop = shortest_path[k*num_nodes+j].prev_hop;
		       }
		    }
		}
	     }
	
	    //compute next_hop from prev_hop
	    nsaddr_t prev;
	    nsaddr_t new_dst;
	    for (int i=1;i<num_nodes;i++) {
		for (int j=1;j<num_nodes;j++) {
		    new_dst = j;
		    prev = new_dst;
		    while (new_dst!=i) {
			prev = new_dst;
			new_dst = shortest_path[i*num_nodes+new_dst].prev_hop;
		    }
		    shortest_path[i*num_nodes+j].next_hop = prev;
		}
	    }
	
	    /*debug
	    int hops;
	    nsaddr_t next_node;
	    for (int i=1; i<num_nodes;i++) {
		for (int j=1;j<num_nodes;j++) {
		    if (shortest_path[i*num_nodes+j].next_hop == -1) {
			if (shortest_path[i*num_nodes+j].dist == num_nodes+1) {
			    continue;
			}
		    }
		    hops = 0;
		    next_node = i;
		    while (next_node!=j) {
			next_node = shortest_path[next_node*num_nodes+j].next_hop;
			hops++;
		    }
		    assert(hops == shortest_path[i*num_nodes+j].dist);
		}
	    }
	    */
	} 
    next_hop = shortest_path[src*num_nodes + dst].next_hop;
    return  next_hop;
	
}


/* added by Jinyang */
bool
God::isAwake(nsaddr_t index)
{
   double now = Scheduler::instance().clock();
   if (now > wakelist[index]) {
       return false;
    }else {
       return true;
    }
}

/* added by jinyang 
   testing whether two nodes are within reasonable communication distance from each other
   if so, the link error for the routing protocol might indicate something other than
   the next hop moving away, e.g. congestion */
bool
God::isNeighbor(nsaddr_t src, nsaddr_t dst)
{
    double src_x,src_y,src_z;
    double dst_x,dst_y,dst_z;
    
    (nodelist[src])->getLoc(&src_x,&src_y,&src_z); 
    (nodelist[dst])->getLoc(&dst_x,&dst_y,&dst_z); 

    double dist = (src_x - dst_x) * (src_x - dst_x) + (src_y - dst_y) * (src_y - dst_y);
    dist = sqrt(dist);

    if (dist < (RANGE - 10.0)) {
	return true;
    }else{
	return false;
    }
}

#ifdef IDEAL_ROUTE
/* god should know the route to anywhere -Jinyang*/
bool
God::getRouteToLoc(nsaddr_t fromnode, location dstloc, nsaddr_t *route, int maxnodes)
{
    nsaddr_t u,node;
    Quadtree *mytree;
    Quadtree *tree;
    qtree_node *ptr;
    int which_nb,ns,ew;
    double x,y,z,my_x,my_y,my_z,min_x,max_x,min_y,max_y;
    int q_head,q_len,q_tail;
    nsaddr_t dst = 0;
    int stop,power,the_loc;
    int color[num_nodes];
    nsaddr_t predecessor[num_nodes];
    nsaddr_t queue[MAX_Q_LEN];

    //God does not balance the load :-) maybe he should?
    //it just computes the shortest path
    
    //breadth-first search for the dst loc
    //set adjacency matrix
    
    //i suspect this would be slow too

    //convert the dstloc to min_x, max_x,min_y,max_y
    stop = BIGGEST_MASK;
    power = 1;
    while (stop >=2) {
	y = y + power * (the_loc & 0x0001);
	the_loc = the_loc >> 1;
	x = x + power * (the_loc & 0x0001);
	the_loc = the_loc >> 1;
	stop = stop - 2;
        power = power * 2;
    }

    min_x = x * RANGE;
    min_y = y * RANGE;
    //reuse the power variable
    power = (BIGGEST_MASK - dstloc.mask)/2;
    max_x = min_x + RANGE*(pow(2,power));
    max_y = min_y + RANGE*(pow(2,power));

    for (int i=0;i<num_nodes;i++) {
	if (i != fromnode) {
	    color[i] = WHITE;
	    predecessor[i]=0;
	}
    }
    color[fromnode] = GREY;

    //enqueue the source
    q_head = 0;
    q_tail = 0;
    q_len = 1;
    queue[q_head] = fromnode;

    
    while (q_len) {
	u = queue[q_head];
	nodelist[u]->getLoc(&my_x,&my_y,&my_z);
	mytree = nodelist[u]->mytree;

	//get all the neighbors of u

	// get neighbors in the same grid
	ptr = (mytree->head).lh_first;
	for (;ptr;ptr=ptr->node_link.le_next) {

	    node = (nsaddr_t)((MobileNode *)(ptr->node))->index_;

	    if (node == u || (color[node] != WHITE)) {
		continue;
	    }

	    (nodelist[node])->getLoc(&x,&y,&z); 
	    if ((sqrt(x-my_x)*(x-my_x)+(y-my_y)*(y-my_y)) < RANGE) {

		predecessor[node] = u;
		color[node] = GREY;

		if ((x>min_x) && (x<max_x) && (y>min_y) && (y<max_y)) {
		    dst = node;
		    goto NEXT;
		}

		//enqueue my neighbor
		q_tail = (q_tail + 1) % MAX_Q_LEN;
		q_len++;
		assert(q_len <= MAX_Q_LEN);
		queue[q_tail] = node;
	    }
	}

	//get neighbors in adjacent grid
	for (ns=0;ns<3;ns++) {
	    for (ew=0;ew<3;ew++) {

		which_nb = ns*4+ew;
		if (which_nb == 0) continue;

		tree = mytree->getNeighbor(which_nb);
		if (tree==NULL) continue;

		ptr = (tree->head).lh_first;
		for (;ptr;ptr=ptr->node_link.le_next) {

		   node = ((MobileNode *)(ptr->node))->index_;

		   if (color[node] != WHITE) continue;

		   nodelist[node]->getLoc(&x,&y,&z); 
		   if ((sqrt(x-my_x)*(x-my_x)+(y-my_y)*(y-my_y)) < RANGE) {
		       color[node] = GREY;
		       predecessor[node] = u;

		       if ((x>min_x) && (x<max_x) && (y>min_y) && (y<max_y)) {
			   dst = node;
			   goto NEXT;
		       }
		       //enqueue my neighbor
		       q_tail = (q_tail + 1) % MAX_Q_LEN;
		       q_len++;
		       assert(q_len <= MAX_Q_LEN);
		       queue[q_tail] = node;
		    }

		}
	    }
	}

	//dequeue u
	q_head = (q_head+1) % MAX_Q_LEN;
	q_len--;
	assert(q_len>=0);
	color[u] = BLACK;
    }

    return false;

NEXT:
    //fill the route
    assert(dst != 0);
    nsaddr_t *tmp = new nsaddr_t[maxnodes];
    int i,j;
    i = 0;
    while (dst!= fromnode) {
	tmp[i++] = dst;
	dst = predecessor[dst];
	assert(dst != 0);
	assert(i<maxnodes);
    }
    tmp[i]= fromnode;

    assert(i<=maxnodes);
    //inverse it!
    j = 0;
    while (i>=0) {
	route[j++] = tmp[i--];
    }
    delete tmp;
    return true;
}
#endif

int 
God::command(int argc, const char* const* argv)
{
        if (argc == 2) {
                if(strcmp(argv[1], "dump") == 0) {
                        int i, j;

                        for(i = 1; i < num_nodes; i++) {
                                fprintf(stdout, "%2d) ", i);
                                for(j = 1; j < num_nodes; j++)
                                        fprintf(stdout, "%2d ",
                                                min_hops[i * num_nodes + j]);
                                fprintf(stdout, "\n");
                        }
                        return TCL_OK;
                }
	}
        else if(argc == 3) {
                if (strcasecmp(argv[1], "num_nodes") == 0) {
                        assert(num_nodes == 0);
                        // allow for 0 based to 1 based conversion
                        num_nodes = atoi(argv[2]) + 1;
                        min_hops = new int[num_nodes * num_nodes];
                        bzero((char*) min_hops,
                              sizeof(int) * num_nodes * num_nodes);

                        instance_ = this;

			wakelist = new double[num_nodes];
			wakeup_list = new double[num_nodes];
			for (int i=0;i<num_nodes;i++) {
			    wakelist[i] = 0.0;
			    wakeup_list[i] = 0.0;
			}
			
			// allocate space to contain the reference to all the nodes
			//nodelist = 0;			
			nodelist = new MobileNode*[num_nodes];

			maclist = new Mac*[num_nodes];
			maclog = new mac_log_entry[num_nodes];
			for (int i=1;i<num_nodes;i++) {
			    maclog[i].tx = 0.0;
			    maclog[i].rx = 0.0;
			    maclog[i].backoff = 0.0;
			    maclog[i].useless_backoff = 0.0;
			    maclog[i].defering = 0.0;
			    maclog[i].idle = 0.0;
			    maclog[i].true_idle = 0.0;
			}

#ifdef IDEAL_ROUTE
			assert(T!=NULL);
			double maxX;
			double maxY;
			double len = RANGE;
			int level = 0;

			maxX = T->upperX();
			maxY = T->upperY();

			while ((len < maxX) || (len < maxY)) {
			    level ++;
			    len *= 2;
			}
			root = new Quadtree(T->lowerX(),T->lowerY(),len,len,level,NULL,0);
#endif
                        return TCL_OK;

                }
		else if(strcmp(argv[1], "topography") == 0) {
			T = (Topography*) TclObject::lookup(argv[2]);
			if(T == 0)
				return TCL_ERROR;
			return TCL_OK;
		}
		
        }
	else if (argc == 4) {
	        /* added by Jinyang to take care of wake-sleep scenarios
		*/
		if (strcasecmp(argv[1],"wakeup") == 0 ) {
		    int index = atoi(argv[2]);    
		    //update the wakelist accordingly
		    wakelist[index] = Scheduler::instance().clock()+ atof(argv[3]);

		    //when this guy has woken up
		    wakeup_list[index] = Scheduler::instance().clock();

		    return TCL_OK;
		}
	}
        else if(argc == 5) {
                if (strcasecmp(argv[1], "set-dist") == 0) {
                        int i = atoi(argv[2]);
                        int j = atoi(argv[3]);
                        int d = atoi(argv[4]);

                        assert(i > 0 && i < num_nodes);
                        assert(j > 0 && j < num_nodes);

                        min_hops[i * num_nodes + j] = d;
                        min_hops[j * num_nodes + i] = d;
                        return TCL_OK;
                }
        } 
        return Connector::command(argc, argv);
}





/* lines_intersect:  AUTHOR: Mukesh Prasad  
 *  
 *   This function computes whether two line segments,  
 *   respectively joining the input points (x1,y1) -- (x2,y2)  
 *   and the input points (x3,y3) -- (x4,y4) intersect.  
 *   If the lines intersect, the output variables x, y are  
 *   set to coordinates of the point of intersection.  
 *  
 *   All values are in integers.  The returned value is rounded  
 *   to the nearest integer point.  
 *  
 *   If non-integral grid points are relevant, the function  
 *   can easily be transformed by substituting floating point  
 *   calculations instead of integer calculations.  
 *  
 *   Entry  
 *        x1, y1,  x2, y2   Coordinates of endpoints of one segment.  
 *        x3, y3,  x4, y4   Coordinates of endpoints of other segment.  
 *  
 *   Exit  
 *        x, y              Coordinates of intersection point.  
 *  
 *   The value returned by the function is one of:  
 *  
 *        DONT_INTERSECT    0  
 *        DO_INTERSECT      1  
 *        COLLINEAR         2  
 *  
 * Error conditions:  
 *  
 *     Depending upon the possible ranges, and particularly on 16-bit  
 *     computers, care should be taken to protect from overflow.  
 *  
 *     In the following code, 'long' values have been used for this  
 *     purpose, instead of 'int'.  
 *  
 */  

#define DONT_INTERSECT    0  
#define DO_INTERSECT      1  
#define COLLINEAR         2  

/**************************************************************  
 *                                                            *  
 *    NOTE:  The following macro to determine if two numbers  *  
 *    have the same sign, is for 2's complement number        *  
 *    representation.  It will need to be modified for other  *  
 *    number systems.                                         *  
 *                                                            *  
 **************************************************************/  

int sign(double d) { return d >= 0 ? 1 : -1; }

// #define SAME_SIGNS( a, b ) (((long) ((unsigned long) a ^ (unsigned long) b)) >= 0 )
#define SAME_SIGNS(a, b) (sign(a) == sign(b))

int
God::lines_intersect(double x1, double y1, double x2, double y2,  
		     double x3, double y3, double x4, double y4,  
		     double *x, double *y)  
{  
  double a1, a2, b1, b2, c1, c2; /* Coefficients of line eqns. */  
  double r1, r2, r3, r4;         /* 'Sign' values */  
  double  denom, offset, num;     /* Intermediate values */  

  /* Compute a1, b1, c1, where line joining points 1 and 2  
   * is "a1 x  +  b1 y  +  c1  =  0".  
   */  

  a1 = y2 - y1;  
  b1 = x1 - x2;  
  c1 = x2 * y1 - x1 * y2;  

  /* Compute r3 and r4. */  
  r3 = a1 * x3 + b1 * y3 + c1;  
  r4 = a1 * x4 + b1 * y4 + c1;  

  /* Check signs of r3 and r4.  If both point 3 and point 4 lie on  
   * same side of line 1, the line segments do not intersect.  
   */  

  if ( r3 != 0 &&  
       r4 != 0 &&  
       SAME_SIGNS( r3, r4 ))  
    return ( DONT_INTERSECT );  

  /* Compute a2, b2, c2 */  

  a2 = y4 - y3;  
  b2 = x3 - x4;  
  c2 = x4 * y3 - x3 * y4;  

  /* Compute r1 and r2 */  

  r1 = a2 * x1 + b2 * y1 + c2;  
  r2 = a2 * x2 + b2 * y2 + c2;  

  /* Check signs of r1 and r2.  If both point 1 and point 2 lie  
   * on same side of second line segment, the line segments do  
   * not intersect.  
   */  

  if ( r1 != 0 &&  
       r2 != 0 &&  
       SAME_SIGNS( r1, r2 ))  
    return ( DONT_INTERSECT );  

  /* Line segments intersect: compute intersection point.   
   */  

  denom = a1 * b2 - a2 * b1;  
  if ( denom == 0 )  
    return ( COLLINEAR );  
  offset = denom < 0 ? - denom / 2 : denom / 2;  

  /* The denom/2 is to get rounding instead of truncating.  It  
   * is added or subtracted to the numerator, depending upon the  
   * sign of the numerator.  
   */  

  num = b1 * c2 - b2 * c1;  
  *x = ( num < 0 ? num - offset : num + offset ) / denom;  

  num = a2 * c1 - a1 * c2;  
  *y = ( num < 0 ? num - offset : num + offset ) / denom;  

  return ( DO_INTERSECT );  
} /* lines_intersect */ 


