/* -*-	Mode:C++; c-basic-offset:8; tab-width:8; indent-tabs-mode:t -*- 
 *
 * Copyright (c) 1997, 2000 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Header: /home/cr1/benjie/cvsroot/ns/ns-span/cmu/energy-model.h,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $
 */

// Contributed by Satish Kumar (kkumar@isi.edu)

#ifndef _energy_model_h_
#define _energy_model_h_

#include <cstdlib>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include "config.h"
#include "trace.h"
#include "rng.h"

const int CHECKFREQ = 1;
const int MAX_WAITING_TIME = 11;

class EnergyModel;
class MobileNode;

class EnergyModel : public TclObject {
public: 
  EnergyModel(MobileNode* n, double energy) : 
    energy_(energy), initialenergy_(energy), node_(n), log_target_(0)
  {
  }

  inline double energy() const 		{ return energy_; }
  inline double initialenergy() const 	{ return initialenergy_; }
  inline void setinitialenergy(double e) { initialenergy_ = e; }
  inline void setenergy(double e) 	{ energy_ = e; }

  inline virtual double MaxTxtime(double P_tx) const   
    { return(energy_/P_tx); }
  inline virtual double MaxRcvtime(double P_rcv) const 
    { return(energy_/P_rcv); }
  inline virtual double MaxIdletime(double P_idle) const 
    { return(energy_/P_idle); }

protected:

  virtual void DecrTxEnergy(double txtime, double P_tx);
  virtual void DecrRcvEnergy(double rcvtime, double P_rcv);
  virtual void DecrIdleEnergy(double idletime, double P);
  
  double energy_;
  double initialenergy_;
  
  MobileNode *node_;
  Trace *log_target_;

private:
  int command(int argc, const char*const* argv);

  friend class SharedMedia;
};

#endif // _energy_model_h

