/*
  channel.cc
  $Id: channel.cc,v 1.2 2001/12/11 22:41:33 benjie Exp $
  */

#include <float.h>

#include <delay.h>
#include <object.h>
#include <packet.h>
#include <trace.h>

#include <cmu/debug.h>
#include <cmu/list.h>
#include <cmu/net-if.h>
#include <cmu/arp.h>
#include <cmu/topography.h>
#include <cmu/node.h>
#include <cmu/channel.h>

static class ChannelClass : public TclClass {
public:
        ChannelClass() : TclClass("Channel") {}
        TclObject* create(int, const char*const*) {
                return (new Channel);
        }
} class_channel;

/* ======================================================================
   NS Initialization Functions
   ====================================================================== */
int
Channel::command(int argc, const char*const* argv)
{

	if(argc == 2) {
		Tcl& tcl = Tcl::instance();

		if(strncasecmp(argv[1], "id", 2) == 0) {
			tcl.resultf("%d", index);
			return TCL_OK;
		}
	}
	else if(argc == 3) {
		TclObject *obj;

		if( (obj = TclObject::lookup(argv[2])) == 0) {
			fprintf(stderr, "%s lookup failed\n", argv[1]);
			return TCL_ERROR;
		}

		if(strncasecmp(argv[1], "addif", 5) == 0) {
			((NetIf*) obj)->insertchnl(this, &ifhead);
			return TCL_OK;
		}
	}
	return TclObject::command(argc, argv);
}


/* ======================================================================
   Other class functions
   ====================================================================== */
static int ChannelIndex = 0;

Channel::Channel()
{
	index = ChannelIndex++;
	LIST_INIT(&ifhead);
}


void
Channel::recv(Packet *p, NetIf *tifp)
{
	send(p, tifp);
}


void
Channel::send(Packet* p, NetIf *tifp)
{
	Scheduler	&s = Scheduler::instance();
	MobileNode	*tnode = tifp->node();
	NetIf		*rifp = ifhead.lh_first;
	MobileNode	*rnode = 0;
	double		propdelay;
	Packet		*newp;

	for( ; rifp; rifp = rifp->nextchnl()) {
		rnode = rifp->node();
		
		if(rnode == tnode)
			continue;

#if 1
        	/* HACK - don't even bother with nodes far far away */
        	double rX, rY, rZ;
        	double tX, tY, tZ;
        	((MobileNode*)tnode)->getLoc(&tX, &tY, &tZ);
        	((MobileNode*)rnode)->getLoc(&rX, &rY, &rZ);
        	double d = sqrt((rX-tX) * (rX-tX) +
                        	(rY-tY) * (rY-tY) + (rZ-tZ) * (rZ-tZ));
        	if (d > 700) continue;
#endif
		
		/*
		 * Each node needs to get their own copy of this packet.
		 * Since collisions occur at the receiver, we can have
		 * two nodes canceling and freeing the *same* simulation
		 * event.
		 *
		 */
		newp = p->copy();

		/*
		 * Each node on the channel receives a copy of the
		 * packet.  The propagation delay determines exactly
		 * when the receiver's interface detects the first
		 * bit of this packet.
		 */
		propdelay = tnode->propdelay(rnode);

		if (propdelay < 0.0)
		    assert(0);
		if (propdelay == 0.0) {
		  /* if the propdelay is 0 b/c two nodes are on top of 
		     each other, move them slightly apart -dam 7/28/98 */
		  propdelay = 2 * DBL_EPSILON;
		  printf ("propdelay 0: %d->%d at %f\n",
			  tnode->index(), rnode->index(), s.clock());
		}
		s.schedule(rifp, newp, propdelay);
	}
		Packet::free(p);
}

void
Channel::dump(void)
{
	NetIf *n;

	fprintf(stdout, "Network Interface List\n");
 	for(n = ifhead.lh_first; n; n = n->nextchnl() )
		n->dump();
	fprintf(stdout, "--------------------------------------------------\n");
}

