/*
 * Copyright (c) 1991,1993 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: /home/cr1/benjie/cvsroot/ns/ns-span/nam/animation.cc,v 1.1.1.1 2001/11/15 19:43:42 benjie Exp $ (LBL)";
#endif

#include "animation.h"

Animation::Animation(double tim, long offset)
{
	paint_ = 0;
	next_ = 0;
	prev_ = 0;
	bb_.xmin = 0;
	bb_.xmax = 0;
	bb_.ymin = 0;
	bb_.ymax = 0;
	si_.time = tim;
	si_.offset = offset;
}

Animation::~Animation()
{
	*prev_ = next_;
	if (next_ != 0)
		next_->prev_ = prev_;
}

void Animation::insert(Animation **head)
{
	next_ = *head;
	if (next_ != 0)
		next_->prev_ = &next_;
	prev_ = head;
	*head = this;
}

void Animation::update(double now)
{
	/* do nothing */
}

void Animation::reset(double now)
{
	/* do nothing */
}

int Animation::inside(double now, float px, float py) const
{
	return (0);
}

const char* Animation::info() const
{
	return (0);
}
