#!/usr/local/bin/perl


sub usage {
    print "usage: tr-to-plotable <from node> <to node> [port] <trace file>\n";
    print "    looks for tcp connection from:port -> to:port and outputs segment nums\n";
    print "    assumes there is only one such connection.  defaults port to wildcard\n";
    die;
}

if ($#ARGV == 2) {
    $from = shift;
    $to = shift;
    $port = -1;
} elsif ($#ARGV == 3) {
    $from = shift;
    $to = shift;
    $port = shift;
} else {
    usage;
}

# used to make sure there's only one conneciton
my $from_spec = "";
my $to_spec = "";


if (-1 == $port) {
    $ss = "^r (\\d+\.\\d+) _$to\_ AGT.*tcp.*\\[(\\d+:\\d+) (\\d+:\\d+) .*\\[(\\d+) \\d+\\]";
} else {
    $ss = "^r (\\d+\.\\d+) _$to\_ AGT.*tcp.*\\[(\\d+:$port) (\\d+:$port) .*\\[(\\d+) \\d+\\]";
}

while(<>) {
#r 29.54 _10_ AGT  --- 3430 tcp 1500 [0 0 a 5 800] ------- [3:27 10:6 32 10] [1367 0] 0 3

    if (/$ss/o) {

	if ($from_spec eq "") { $from_spec = $2; $to_spec = $3;  }
	if ($from_spec ne "" && ($2 ne $from_spec || $3 ne $to_spec)) {
	    print "\nScript can't handle multiple connections between traced nodes\n";
	    print "  between nodes $from -> $to are at least two TCP connections:\n";
	    print "  $from_spec - > $to_spec  and $2 -> $3\n";
	    die;
	}
	print "$1\t$4\n";
    }
}

