#!/usr/local/bin/perl

#if ($#ARGV != 2) {
#    print "usage: tr-to-plotable <from node> <to node> <trace file>\n";
#    print "    looks for tcp connection from -> to and outputs segment nums\n";
#    die   "    assumes there is only one such connection\n";
#}

my $input_cp = "sa-base.cp";
my $xfer_size = 20547;   # 20547pkts @ 1460 each => 30MB
my $mac_layer = "Mac/802_11";
my $mac_label = "UNKNOWN";
my $scen = "recon";
my $testport = 36;

my $ip1 = "128.2.250.144"; #     farm7 data src
my $ip2 = "128.2.250.51"; #   farm2 data sink
my $phys_if = "xl0";


my $edst = "00:60:08:af:ea:24";  # ether addr of data sink

if ($mac_layer eq 'Mac/NULL') {
    $mac_label = 'macnull';
} elsif ($mac_layer eq 'Mac/802_11') {
    $mac_label = 'mac802';
}



sub perf {
    print "@_\n";
    system(@_);
}

my $src = 2;
my $dst = 9;

for ($dst = 1; $dst <= 16; $dst++)
{
    next if ($dst == $src);

    print "\n\n Begining for source $src and dst $dst\n\n";

    perf("rm -f conn.cp");
    perf("cp $input_cp conn.cp");

    open CPF,">>conn.cp" or die "can't open connection pattern file conn.cp";

    print CPF <<"HERE"
\#\# Add direct emulation
source emulate/ns-emulate.tcl

AddEmulationChannel $src \"$ip1\" $dst \"$ip2\" \"$phys_if\"

HERE
;
    close(CPF);
    
    perf("ssh -x -l root $ip2 tcpdump -w dump src $ip1 and ether dst $edst and tcp and port ftp-data &");


    sleep(2);
    print "starting nse now ... \n";
    perf("./nse cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl -sc $scen -cp conn.cp " .
	 " -cmd \"ssh -x -l dmaltz $ip1 ./startftp.csh &\" -mac $mac_layer");

    print "retrieving log files ...\n";
    perf("ssh -x $ip1 killall ftp");
    perf("ssh -x $ip2 killall tcpdump");
    perf("scp root\@$ip2:dump .");
    perf("tcpdump -r dump | emulate/dump-to-plottable.pl > regression/recon-$dst-$mac_label-nse.plot");

    perf("scp regression/recon-$dst-$mac_label-nse.plot dmaltz\@ARES.ODYSSEY.CS.CMU.EDU:regression/");
}
