#!/usr/local/bin/perl

use English;

if ($#ARGV != 1) {
    die "usage: demo.pl <from node> <to node> \n";
}


my $src = shift;
my $dst = shift;

my $output = "demo";
my $input_cp = "ntr-scen/sa-base.cp";
my $xfer_size = 20547;   # 20547pkts @ 1460 each => 30MB
my $mac_layer = "Mac/802_11";
my $mac_label = "UNKNOWN";
my $scen = "ntr-scen/recon";
my $testport = 36;

if ($mac_layer eq 'Mac/NULL') {
    $mac_label = 'macnull';
} elsif ($mac_layer eq 'Mac/802_11') {
    $mac_label = 'mac802';
}



sub perf {
    print "@_\n";
    system(@_);
}

print "\n\n Begining for source $src and dst $dst\n";
print "  scenario file: $scen  MAC layer: $mac_layer\n\n";

    perf("rm -f conn.cp");
    perf("cp $input_cp conn.cp");

    perf("cmu/scripts/add-ntrwkld.pl conn.cp $src $dst");
    perf("time ./ns cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl -sc $scen -cp conn.cp -mac $mac_layer");
    perf("grep '^P' out.tr > $output-ntrwkld");

perf("scp $output-ntrwkld ares:");

print "\n\nPress return to begin simulation of ftp between $src and $dst\n";
<STDIN>;

    perf("rm -f conn.cp");
    perf("cp $input_cp conn.cp");

    open CPF,">>conn.cp" or die "can't open connection pattern file conn.cp";

    print CPF <<"HERE"
	set testport $testport
	set s_type "TCP/Reno"
	set d_type "TCPSink"
        set pktClass 0
	set source \$node_($src)
	set dest \$node_($dst)

	set s_agent [new Agent/\$s_type]
	set d_agent [new Agent/\$d_type]
	\$s_agent set fid_ \$pktClass
	\$d_agent set fid_ \$pktClass
	\$source attach \$s_agent \$testport
	\$dest attach \$d_agent \$testport
	\$ns_ connect \$s_agent \$d_agent

	set tcp_(test) \$s_agent

	\$tcp_(test) set packetSize_ 1460
	set ftp_(test) [\$tcp_(test) attach-source FTP]
	\$ftp_(test) set  maxpkts_ $xfer_size
	\$ns_ at 0.10 "\$ftp_(test) start"
HERE
;
    close(CPF);

    perf("time ./ns cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl -sc $scen -cp conn.cp -mac $mac_layer");

    perf("emulate/tr-to-plottable.pl $src $dst $testport out.tr > $(output).tsp");

print "Press return when ready to transfer tsp files ...\n";
<STDIN>;

    perf("scp $(output).tsp ares:");

