#!/usr/local/bin/perl

my $input_cp = "ntr-scen/sa-base.cp";
my $xfer_size = 20547;   # 20547pkts @ 1460 each => 30MB
my $mac_layer = "Mac/802_11";
my $mac_label = "UNKNOWN";
my $scen = "ntr-scen/recon";
my $testport = 36;

my $ip1 = "128.2.250.144"; #     farm7 data src
my $ip2 = "128.2.250.51"; #   farm2 data sink
my $phys_if = "xl0";

my $emu1;
my $emu2;

my $edst = "00:60:08:af:ea:24";  # ether addr of data sink

if ($#ARGV == 2) {
    $emu1 = shift;
    $emu2 = shift;
    $scen = shift;
} elsif ($#ARGV == 1) {
    $emu1 = shift;
    $emu2 = shift;
} else {
    print "usage: Start-nse <from node> <to node> [<scenario file>]\n";
    die;
}

if ($mac_layer eq 'Mac/NULL') {
    $mac_label = 'macnull';
} elsif ($mac_layer eq 'Mac/802_11') {
    $mac_label = 'mac802';
}



sub perf {
    print "@_\n";
    system(@_);
}

    print "\n\n Begining for source $emu1 and sink $emu2\n\n";

    perf("rm -f conn.cp");
    perf("cp $input_cp conn.cp");

    open CPF,">>conn.cp" or die "can't open connection pattern file conn.cp";

    print CPF <<"HERE"
\#\# Add direct emulation
source emulate/ns-emulate.tcl

AddEmulationChannel $emu1 \"$ip1\" $emu2 \"$ip2\" \"$phys_if\"

HERE
;
    close(CPF);
    
    perf("ssh -x -l root $ip2 tcpdump -w dump src $ip1 and ether dst $edst and tcp and port ftp-data &");


    sleep(2);
    print "starting nse now ... \n";
    perf("./nse cmu/scripts/run.tcl -rp cmu/dsr/dsr.tcl -sc $scen -cp conn.cp " .
	 " -cmd \"ssh -x -l ns $ip1 ./startftp.csh &\" -mac $mac_layer " .
#	 " -tr /dev/null " .
	 "");

    print "retrieving log files ...\n";
    perf("ssh -x $ip1 killall ftp");
    perf("ssh -x $ip2 killall tcpdump");
    perf("scp root\@$ip2:dump .");
    perf("tcpdump -r dump | emulate/dump-to-plottable.pl > demo-nse.plot");

   # perf("scp demo-nse.plot dmaltz\@ares.CODA.CS.CMU.EDU:");

