#include <stdlib.h>

#include <scheduler.h>
#include <cmu/marshall.h>
#include <cmu/tsftimer.h>

TSFTimer::TSFTimer(int index) {
    offset_ = (u_int64_t)random() << 32 | (u_int64_t)random();
//      printf("%d's tsf is %lld\n", index, offset_ +
//  	   (u_int64_t)(Scheduler::instance().clock() * 1e6)); //DEBUG
}

u_int64_t TSFTimer::getTSF() {
    return offset_ + (u_int64_t)(Scheduler::instance().clock() * 1e6);
}

void TSFTimer::setTSF(u_int64_t tsf) { 
    offset_ = tsf - (u_int64_t)(Scheduler::instance().clock() * 1e6);
}
