#!/usr/bin/perl

# for each n/scen combination, run sims adaptively with offered loads
# starting at $start_load, every $load_interval.  Stop when
# $max_drop_frac is exceeded, then run sims at $fine_rate_interval
# back from the last one for $fine_load_range.

# usage: run2.pl <pkt-sz> <scen-list> <out-dir>
# run out of cmu/test_capacity dir

$| = 1;

$t = 300;
$load_interval = 0.1; # Mbps
$fine_load_interval = 0.025;
$fine_load_range = 0.2;
$max_drop_frac = 0.2;

%start_load = ();
$start_load{100} = 0.20; # Mbps
$start_load{200} = 0.20;
$start_load{300} = 0.10;
$start_load{400} = 0.05;
$start_load{500} = 0.05;
$start_load{600} = 0.05;

# usage: run2.pl <pkt-size> <scen-list> <out-dir>

$debug = 0;

$pktsz = $ARGV[0];
$scen_list = $ARGV[1];
$out_dir = $ARGV[2];

randomize();

sub my_system {
    if ($debug) {
	print @_, "\n";
    }
    else {
	$rc = system @_;
	# return value code processing, pg. 230, ``programming perl'', turquoise book
	$rc = 0xffff & $rc;
	if ($rc != 0) {
	    $failed_commands++;
	    if ($rc == 0xff00) {
		$rc = $rc >> 8;
		print("NON-ZERO EXIT: $rc  (@_)\n");
	    }
	    else {
		$sig = $rc; 
		$coredump = "";
		if ($rc & 0x80) {
		    $coredump = "(DUMPED CORE) ";
		    $sig = $rc & ~0x80;
		}
		print("RECEIVED SIGNAL $sig $coredump (@_)\n");
	    }
	}
    }
}

open(LIST, $scen_list);

while ($_ = <LIST>) {
    
    if (/^#/) {
	next;
    }

    print "XXX: $_";

    if (/rand-(\d+)-(\d+)x(\d+)-(\d+)/) {
	$n = $1;
	$l1 = $2;
	$l2 = $3;
	$nonce = $4;

	if ($l1 != $l2) {
	    print stderr "sides not equal: $_, skipping\n";
	    next;
	}
	
	chop $_; # remove trailing newline on scen file

	$first_load = $start_load{$n};

	$drop_rate = 0;
	for ($load = $first_load; $drop_rate < $max_drop_frac; $load += $load_interval) {
	    $seed = rand;

	    $r = $load * 1e6 / ($n * $pktsz * 8);
	    
	    $start_time = time();
	    $st = localtime($start_time);
	    print "XXX Starting new sim at $st\n";

	    print "XXX nominal load: $load\n";
	    print "XXX desired rate: $r\n";

	    $tr = "$out_dir/$pktsz-$l1x$l1-$n-$nonce-$r-$seed.tr";
	    $out = "$out_dir/$pktsz-$l1x$l1-$nonce-$r-$seed.out";
	    $cmd = "/tmp/ns-random run.tcl -seed $seed -rp testmac.tcl -sc scen/random-scen/$_ -x $l1 -y $l1 -pktsize $pktsz -pktrate $r -nn $n -chain 1 -fracsend 1.0 -tr $tr";
	    print "XXX cmd: $cmd\n";
	    print "XXX tr: $tr\n";
	    print "XXX out: $out\n";
	    print "XXX scen $_\n";
	    print "XXX n: $n\n";
	    print "XXX rate: $r\n";
	    my_system "$cmd";

	    $end_time = time();
	    $et = localtime($end_time);
	    print "XXX Ending sim at $et\n";


	    my_system "perl totals.pl $tr RTR $n > $out";
	    my_system "gzip $tr";
	    $tmp = "/tmp/sim-data-$$";
	    ($pkt_sent, $pkt_drop) = split ' ', `extract-data.pl $out`;

	    $data_file = "$out_dir/data-$pktsz-$l1x$l1-$n";
	    my_system "echo \"# $cmd \" >> $data_file";
	    my_system "echo \"$pkt_sent\t$pkt_drop\" >> $data_file";

	    $drop_rate = $pkt_drop / $pkt_sent;
	    print "XXX drop rate: $drop_rate\n";

	    $end_time2 = time();
	    
	    print "XXX End processing\n";
	    $run_hours = ($end_time - $start_time) / 3600;
	    $process_mins = ($end_time2 - $end_time) / 60;
	    print "XXX Simulation time: $run_hours hours\n";
	    print "XXX Post-processing time: $process_mins minutes\n";
	    print "XXX ---------------------------------------------\n";

	}
    }
}


sub randomize {
    my $seed = $$;  #  $$ is pid
    my $buf;

    open(RAND_FILE,"/dev/urandom") or die "cannot open /dev/urandom";
    read(RAND_FILE,$buf, 4);
    $seed ^= $buf;

    close RAND_FILE;
    srand $seed;
}

