#!/usr/bin/perl

$| = 1;

%rates = ();

# $rates{100} = [0.400, 0.500, 0.600];
$rates{100} = [0.400, 0.500, 0.600, 0.625, 0.650, 0.675, 0.700, 0.725, 0.750, 0.775, 0.800, 0.900, 1.000];
$rates{200} = [0.200, 0.300, 0.400, 0.425, 0.450, 0.475, 0.500, 0.525, 0.550, 0.575, 0.600, 0.700, 0.800];
$rates{300} = [0.100, 0.200, 0.300, 0.325, 0.350, 0.375, 0.400, 0.425, 0.450, 0.475, 0.500, 0.600, 0.700];
$rates{400} = [0.050, 0.150, 0.250, 0.275, 0.300, 0.325, 0.350, 0.375, 0.400, 0.425, 0.450, 0.550, 0.650];
$rates{500} = [0.050, 0.100, 0.200, 0.225, 0.250, 0.275, 0.300, 0.325, 0.350, 0.375, 0.400, 0.500, 0.600];
$rates{600} = [0.050, 0.100, 0.200, 0.225, 0.250, 0.275, 0.300, 0.325, 0.350, 0.375, 0.400, 0.500, 0.600];

# usage: run.pl <scen-list> <out-dir>

$debug = 0;

$scen_list = $ARGV[0];
$out_dir = $ARGV[1];

randomize();

sub my_system {
    if ($debug) {
	print @_, "\n";
    }
    else {
	$rc = system @_;
	# return value code processing, pg. 230, ``programming perl'', turquoise book
	$rc = 0xffff & $rc;
	if ($rc != 0) {
	    $failed_commands++;
	    if ($rc == 0xff00) {
		$rc = $rc >> 8;
		print("NON-ZERO EXIT: $rc  (@_)\n");
	    }
	    else {
		$sig = $rc; 
		$coredump = "";
		if ($rc & 0x80) {
		    $coredump = "(DUMPED CORE) ";
		    $sig = $rc & ~0x80;
		}
		print("RECEIVED SIGNAL $sig $coredump (@_)\n");
	    }
	}
    }
}

open (LIST, $scen_list);

while ($_ = <LIST>) {
    
    if (/^#/) {
	next;
    }

    print "XXX: $_";

    if (/rand-(\d+)-(\d+)x(\d+)-(\d+)/) {
	$n = $1;
	$l1 = $2;
	$l2 = $3;
	$nonce = $4;
	$seed = rand;

	if ($l1 != $l2) {
	    print stderr "sides not equal: $_, skipping\n";
	    next;
	}
	
	$num_rates = $#{$rates{$n}} + 1;

	chop $_; # remove trailing newline


	for ($i = 0; $i < $num_rates; $i++) {
	    $r = $rates{$n}[$i];
	    $tr = "$out_dir/1500-low-$n-$nonce-$r-$seed.tr";
	    $out = "$out_dir/1500-low-$n-$nonce-$r-$seed.out";
	    $cmd = "../../ns run.tcl -seed $seed -rp testmac.tcl -sc scen/random-scen/$_ -x $l1 -y $l1 -pktsize 1500 -pktrate $r -nn $n -chain 1 -fracsend 1.0 -tr $tr";
	    print "XXX cmd: $cmd\n";
	    print "XXX tr: $tr\n";
	    print "XXX out: $out\n";
	    print "XXX scen $_\n";
	    print "XXX n: $n\n";
	    print "XXX rate: $r\n";
	    my_system "$cmd";
	    my_system "perl totals.pl $tr RTR $n > $out";
	    my_system "gzip $tr";
	    my_system "extract-data.pl $out >> $out_dir/data-1500-low-$n";
	}
    }
}


sub randomize {
    my $seed = $$;  #  $$ is pid
    my $buf;

    open(RAND_FILE,"/dev/urandom") or die "cannot open /dev/urandom";
    read(RAND_FILE,$buf, 4);
    $seed ^= $buf;

    close RAND_FILE;
    srand $seed;
}

