#!/usr/bin/perl

# usage: plot.pl <file> <n> <t> <pktsize> [<view-now>]

$file = $ARGV[0];
$n = $ARGV[1];
$t = $ARGV[2];
$pktsize = $ARGV[3];
$view = $ARGV[4];

$out1 = "$file.thruput.ps";
$out2 = "$file.drop.ps";

open(P, "| gnuplot > $out1");

print P "set terminal postscript \n";
print P "set xlabel 'Agreggate Offered Load (Mbps)'\n";
print P "plot '$file' using (\$1*$pktsize*8/($t*1e6)):((\$1-\$2)*$pktsize*8/($t*1e6)) title '$n nodes, $pktsize byte packets'\n";
close P;

open(P, "| gnuplot > $out2");

print P "set terminal postscript \n";
print P "set xlabel 'Agreggate Offered Load (Mbps)'\n";
print P "plot '$file' using (\$1*$pktsize*8/($t*1e6)):(\$2/\$1) title '$n nodes, $pktsize byte packets'\n";
close P;


if ($view > 0) {
    system "gv $out1 & gv $out2";
}


