
#ifndef SPANAGENT_HH
#define SPANAGENT_HH

#include <vector>
#include <packet.h>
#include <stdarg.h>
#include <agent.h>
#include <trace.h>
#include <connector.h>
#include <packet.h>
#include <random.h>
#include <cmu/priqueue.h>
#include <cmu/cmu-trace.h>
#include <cmu/energy-model.h>
#include <cmu/mac.h>
#include <cmu/mac-802_11.h>
#include <cmu/sharedmedia.h>
#include <scheduler.h>
#include "hdr_span.h"
#include "neibtab.hh"

#define SPAN_ENERGY_ACTIVE   10.0 // node alive above this level

extern double SpanBcast;

class SpanAgent;

class SpanAnnounceCoordinatorHandler : public Handler { 
public: 
  SpanAnnounceCoordinatorHandler(SpanAgent *r) : _agent(r) {}
  void handle(Event *e); 
private: 
  SpanAgent *_agent;
};

class SpanEventHandler : public Handler { 
public: 
  SpanEventHandler(SpanAgent *r) 
    : _agent(r), 
      _last_broadcast(0), 
      _last_announce_check(0), 
      _last_withdraw_check(0),
      _last_withdraw(0) {}
  void handle(Event *e); 
private: 
  SpanAgent *_agent;
  double _last_broadcast;
  double _last_announce_check;
  double _last_withdraw_check;
  double _last_withdraw;
};

class GFRouter;
class NeighborTable;

class SpanAgent : public Agent {
  friend class SpanEventHandler;
protected:
  NeighborTable _neighbors;

private:
  SpanEventHandler _event_handler;
  SpanAnnounceCoordinatorHandler _announce_coordinator_handler;
  Event _event_handler_event;

  bool _is_coordinator;
  bool _asleep;
  bool _usespan;
  bool _usepsm;
  bool _is_tentative;
  int _srcsink;

  bool _announce_pending;
  double _last_bcast;
  unsigned _withdraw_meter;
  double _last_withdraw;
  double _last_withdraw_seen;
  double _last_force;
  int _force_counter;

  nsaddr_t _my_id;
  int _off_mac;
  int _off_ll;
  int _off_ip;
  int _off_span;
  int _off_span_hello;
  int _off_span_poll;
  NsObject *_ll;
  PriQueue *_ifq;
  PriQueue *_real_ifq;
  MobileNode *_mobile_node;
  EnergyModel *_energy_model;
  Mac802_11 *_mac;
  SharedMedia *_netif;

  unsigned _pkts_sent;
  unsigned _pkts_received;
  unsigned _pkts_hops;
  
  GFRouter *_gfrt;
  void forward_pkt(Packet *p);
  void send_packet(Packet *p, bool);

  void process_span_hdr(Packet *p);
  void process_span_hello(Packet *p);
  void add_span_hdr(Packet *p);
  
  int check_announce();
  bool check_withdraw(bool);
  
public:
  SpanAgent();

  bool alive() const;
  bool active() const;
  int id() const 		{ return _my_id; }
  bool is_coordinator() const 	{ return _is_coordinator; }
  bool asleep() const		{ return _asleep; }
  double last_withdraw() const  { return _last_withdraw; }

  virtual int command(int argc, const char*const* argv);
  virtual void recv(Packet *, Handler *callback = 0);
  
  void start();
  void wakeup();
  void sleep();
  void update_location(); 
  void dump_table();
  
  void broadcast_hello();
  double check_announce_handler();
  bool check_withdraw_handler();
  
  bool check_withdraw_coordinator(bool);
  bool check_announce_coordinator();
  void announce_coordinator(bool force=false);
  void withdraw_coordinator();

private:
  static void tx_failure_cb(Packet *p, void *thunk);
};
  
inline bool 
SpanAgent::alive() const
{ 
  return _mobile_node->energy_model()->energy() > 0;
}

inline bool
SpanAgent::active() const
{
  return _mobile_node->energy_model()->energy() > SPAN_ENERGY_ACTIVE;
}

#endif

