#!/usr/bin/perl

$nodes = 120;
$nodes_skip = 20;
$stop_time = 590;
$dump_period = 20;

my $period = 0;
my @time;
my @nannounce;
my @announce;
my @jtime;
my @jstart;
my @jdrain;

$coordinators = 0;

for (my $i=1; $i<=$nodes; $i++) {
 $time[$i] = 0;
 $nannounce[$i] = 0;
 $announce[$i] = 0;
 $jstart[$i] = 0;
 $jdrain[$i] = 0;
 $jtime[$i] = 0;
}

$now = 0;

while (<>) {
  if ($_ =~ /StartOfDump/) {
    my $cur = 40+$period*$dump_period;
    if ($cur > $stop_time) {
      last;
    }
    else {
      $now = $cur;
    }
    $period++;
  }

  if ($_ =~ /# ([\d.]+): (\d+) out of energy/) {
    $nodes--;
    print "$now $nodes\n";
    exit;
  }
  elsif ($_ =~ /# ([\d.]+): (\d+) announce coordinator/) {
    $announce[$2] = $1; 
    $nannounce[$2]++; 
    $coordinators++;
  }
  elsif ($_ =~ /# ([\d.]+): (\d+) withdraw coordinator/) {
    $time[$2] += ($1-$announce[$2])+2;
    $announce[$2] = 0;
    $coordinators--;
  }

  elsif ($_ =~ /^([0-9.]+) ([0-9.]+) ([0-9]+) ([cn])([0-9]+) [0-9]+ [0-9]+ [0-9.]+ ([0-9.]+) ([0-9.]+)/) {
     # posx $1 posy $2 node $3 n/c $4 neighbor $5 Eremain $6 Einit $7
     if ($jstart[$3] == 0) {
       $jstart[$3] = $6;
       $jtime[$3] = $now;
     }
     $jdrain[$3] = $6;
  }
}

$totalTime = 0;
$totalNA = 0;
$totalDrain = 0;

for (my $i=$nodes_skip+1; $i<=$nodes; $i++) {
  if ($announce[$i] > 0) {
    $time[$i] += ($stop_time-$announce[$i]);
    $announce[$i] = 0;
  }
  $totalTime  += $time[$i];
  $totalNA += $nannounce[$i];
  $drain = ($jstart[$i]-$jdrain[$i])/($now-$jtime[$i]);
  $totalDrain += $drain;
  # print "$i $time[$i] $jstart[$i] $jtime[$i] $jdrain[$i] $drain\n";
}

if ($nodes > 0) {
  printf("# now:              %d\n", $now);
  printf("# avg time:         %3.3f\n", $totalTime/($nodes-$nodes_skip));
  printf("# avg announces:    %3.3f\n", $totalNA/($nodes-$nodes_skip));
  printf("# avg consumption:  %3.3f\n", $totalDrain/($nodes-$nodes_skip));
  printf("# total nodes:      %d\n",    $nodes);
}

