#!/usr/bin/perl

my @sent;
my @recv;
my @hops;

for (my $i=0; $i<2000000; $i++) {
 $sent[$i] = 0;
 $recv[$i] = 0;
 $hops[$i] = 0;
}

$totalHops = 0;
$totalLatency = 0;
$numSent = 0;
$numReceived = 0;
$numBUF = 0;
$numRouteHoles = 0;
$numTxFailures = 0;
$numIFQFull = 0;
$numIFQEnd = 0;
$numTTL = 0;
$dupPackets = 0;

while (<>) {
  if ($_ =~ /D ([\d.]+) [0-9_A-Za-z ]+ RCV (\d+) [A-Za-z\d.: \[\]-]+ (\d+) 0$/) {
    if ($sent[$2] > 0 && $recv[$2] == 0) {
      $recv[$2] = $1;
      $hops[$2] = $3;
      $totalHops += $3;
      $totalLatency += ($1-$sent[$2]);
      $t = int(1000*($1-$sent[$2]));
      $numReceived++;
    } 
    elsif ($recv[$2] > 0) {
      $dupPackets++;
    }
  }
  elsif ($_ =~ /s ([0-9.]+) [0-9_]+ AGT  --- (\d+) cbr/) {
    $sent[$2] = $1;
    $numSent++;
  }
  elsif ($_ =~ /D ([0-9.]+) [0-9_]+ RTR  TTL (\d+) cbr/) {
    $numTTL++;
  }
  elsif ($_ =~ /D ([0-9.]+) [0-9_]+ RTR  BUF (\d+) cbr/) {
    $numBUF++;
  }
  elsif ($_ =~ /D ([0-9.]+) [0-9_]+ RTR  GFH (\d+) cbr/) {
    $numRouteHoles++;
  }
  elsif ($_ =~ /D ([0-9.]+) [0-9_]+ RTR  TXF (\d+) cbr/) {
    $numTxFailures++;
  }
  elsif ($_ =~ /D ([0-9.]+) [0-9_]+ IFQ  END (\d+) cbr/) {
    $numIFQEnd++;
  }
  elsif ($_ =~ /D ([0-9.]+) [0-9_]+ IFQ  IFQ (\d+) cbr/) {
    $numIFQFull++;
  }
}

$avgLatency = 1000 * $totalLatency / $numReceived;
$avgHops = $totalHops / $numReceived;

$numSent -= $numIFQEnd;
$numDrops = $numIFQFull + $numTTL + $numRouteHoles + 
            $numBUF + $numTxFailures;
$lossRate = 1-$numReceived/$numSent;

print  "ifq full: $numIFQFull\n";
print  "buf ovfl: $numBUF\n";
print  "ttl:      $numTTL\n";
print  "holes:    $numRouteHoles\n";
print  "tx fail:  $numTxFailures\n";
print  "sent:     $numSent\n";
print  "received: $numReceived\n";
print  "dup pkts: $dupPackets\n";
printf("loss:     %3.3f\n", $lossRate);
printf("latency:  %3.3f\n", $avgLatency);
printf("hops:     %3.3f\n", $avgHops);



