#!/usr/bin/perl
strict;

$period = 5;
$numSent = 0;
$numReceived = 0;
$numZeros = 0;

sub reset_stats {
  $numSent = 0;
  $numReceived = 0;
}

sub calc_stats {
  my ($now, $length, $sent, $recv) = @_;
  printf ("$now %3.3f %3.3f $sent $recv\n", $sent/$length, $recv/$length);
}

reset_stats();

$lastMark = 0;
$now = 0;

while (<>) {
  if ($_ =~ /[rsDf] ([\d.]+) _\d+_/) {
    $now = $1;
  }
  if ($_ =~ /D ([\d.]+) [0-9_A-Za-z ]+ RCV (\d+) [a-z\d.J: \[\]-]+ (\d+) 0$/) {
    $numReceived++;
  }
  elsif ($_ =~ /s ([0-9.]+) [0-9_]+ AGT  --- (\d+) cbr/) { 
    $numSent++;
  }
 
  if ($now > $lastMark + $period) {
    calc_stats($now, $now-$lastMark, $numSent, $numReceived);
    if ($numReceived == 0) { 
      $numZeros++;
      if ($numZeros > 10) { last; }
    } else { $numZeros = 0; }
    reset_stats();
    $lastMark = $now;
  }
}

calc_stats($now, $now-$lastMark, $numSent, $numReceived);

