#ifndef NEIGHBORTABLE_HH
#define NEIGHBORTABLE_HH
#include <stdio.h>
#include <vector>

class LLIterator {
public:
  class Entry {
  public:
    struct Entry *next;
  };
private:
  struct Entry *_list;
  struct Entry *_cptr;
public:
  LLIterator(Entry *e) : _list(e) { _cptr = _list; }
  Entry *peek() { return _cptr; }
  Entry *next() { if (_cptr) _cptr = _cptr->next; return _cptr; }
  void reset() { _cptr = _list; }
};

class NeighborTable {
public:
  class Coordinator : public LLIterator::Entry {
  public:
    Coordinator() {}
    int  id;
    bool tentative;
  };

  class Neighbor : public LLIterator::Entry {
  public:
    int  id;
    int  x;
    int  y;
    int  nounce;
    bool is_coordinator;
    vector<int> neighbors;
    Coordinator *coordinators;

    Neighbor() { coordinators = 0; neighbors.clear(); }
    LLIterator *coord_iter() { return new LLIterator(coordinators); }
  
    void remove_coordinator(int cid) {
      Coordinator *c = coordinators;
      Coordinator *p = 0;
      while (c) {
        if (c->id == cid) {
          if (p)
	    p->next = c->next;
          else
	    coordinators = (Coordinator*) c->next;
	  delete c;
	  break;
	}
	p = c;
	c = (Coordinator*) c->next;
      }
    }
  
    void add_coordinator(int cid, bool tentative) {
      Coordinator *c = coordinators;
      while (c) {
	if (c->id == cid) {
	  c->tentative = tentative;
	  return;
	}
	c = (Coordinator*) c->next;
      }
      c = new Coordinator();
      c->id = cid;
      c->tentative = tentative;
      c->next = coordinators;
      coordinators = c;
    }

    bool find_coordinator(int cid) {
      Coordinator *c = coordinators;
      while (c) {
        if (c->id == cid)
	  return true;
	c = (Coordinator*) c->next;
      }
      return false;
    }

    void clear_coordinators() {
      Coordinator *c = coordinators;
      while (c) {
        Coordinator *t = c;
        c = (Coordinator*) c->next;
        delete t;
      }
      coordinators = 0;
    }

    ~Neighbor() { clear_coordinators(); }

  };

private:
  Neighbor *_neighbors;
  unsigned _nneighbors;

public:
  NeighborTable() { _neighbors = 0; _nneighbors = 0; }
  ~NeighborTable() {
    Neighbor *n = _neighbors;
    while (n) {
      Neighbor *t = n;
      n = (Neighbor*) n->next;
      delete t;
    }
    _neighbors = 0;
    _nneighbors = 0;
  }

  LLIterator *neighbors() { return new LLIterator(_neighbors); }
  unsigned nneighbors() { return _nneighbors; }

  void add_neighbor(struct Neighbor *new_n) {
    remove_neighbor(new_n->id);
    new_n->next = _neighbors;
    _neighbors = new_n;
    _nneighbors++;
  }

  int update_neighbor(struct Neighbor &new_n) {
    Neighbor *n = search_neighbor(new_n.id);
    if (n) {
      n->x = new_n.x;
      n->y = new_n.y;
      n->nounce = new_n.nounce;
      n->is_coordinator = new_n.is_coordinator;
      return 0;
    }
    return -1;
  }

  void remove_neighbor(int id) {
    Neighbor *n = _neighbors;
    Neighbor *p = 0;
    while (n) {
      if (n->id == id) {
        if (p)
          p->next = n->next;
	else
          _neighbors = (Neighbor*) n->next;
	delete n;
	_nneighbors--;
	break;
      }
      p = n;
      n = (Neighbor*) n->next;
    }
  }

  Neighbor* search_neighbor(int id) {
    Neighbor *n = _neighbors;
    while (n) {
      if (n->id == id)
	return n;
      n = (Neighbor*) n->next;
    }
    return 0;
  }

  void add_coordinator(int nid, int cid, bool tentative) {
    Neighbor *n = search_neighbor(nid);
    if (n)
      n->add_coordinator(cid, tentative);
  }
 
  void remove_coordinator(int nid, int cid) {
    Neighbor *n = search_neighbor(nid);
    if (n)
      n->remove_coordinator(cid);
  }
  
  int share_coordinator(int a, int b, int ex);
  int share_neighbor(int a, int b, int ex);
  void expire_old_entries(int myid, int expire);
};
  
#endif


