
#ifndef SPAN_GFRT_HH
#define SPAN_GFRT_HH

#include <packet.h>
#include <scheduler.h>
#include <cmu/cmu-trace.h>
#include "hdr_span.h"
#include "neibtab.hh"

#define GF_TTL  -1
#define GF_HOLE -2
#define GF_FWD   0
#define GF_COORD 1

static inline int
compute_distance(int x1, int y1, int x2, int y2)
{
  return (int)sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
}

class GFRouter {
  int find_next_hop(int id, int dst, int dst_x, int dst_y, bool& coord);
  NeighborTable& _neighbors;

  int distance_between(int neighbor, int dst_x, int dst_y) {
    NeighborTable::Neighbor* n = _neighbors.search_neighbor(neighbor);
    if (!n) {
      fprintf(stderr,"XXX GFRouter fatal, %d asked for, no luck\n", neighbor);
      assert(n);
    }
    int x = n->x;
    int y = n->y;
    assert(x>=0 && y>=0);
    return compute_distance(x, y, dst_x, dst_y);
  }

public:
  GFRouter(NeighborTable &t);
  int forward_pkt(int id, hdr_ip *, hdr_cmn *, hdr_span *);
};

#endif

