/* -*- c++ -*-
   SharedMedia.h
   $Id: sharedmedia.h,v 1.1.1.1 2001/11/15 19:43:17 benjie Exp $

   a SharedMedia network interface

*/

#ifndef _cmu_SharedMedia_h_
#define _cmu_SharedMedia_h_

#include <cmu/net-if.h>
#include <timer-handler.h>
#include <cmu/energy-model.h>
#include <cmu/omni-antenna.h>

class SharedMedia;
class Mac802_11;

class Idle_Timer : public TimerHandler {
 public:
	Idle_Timer(SharedMedia *a) : TimerHandler() { a_ = a; }
 protected:
	virtual void expire(Event *e);
	SharedMedia *a_;
};


// power state for this node
typedef enum { 
  pwr_state_off = 0, 
  pwr_state_idle = 1, 
  pwr_state_sleep = 2
} power_t;

typedef enum {
    pwr_mode_awake = 0,
    pwr_mode_powersave = 1
} power_mode_t;

class SharedMedia : public NetIf {
  static const int CH_STATUS_IDLE = 0;
  static const int CH_STATUS_RECV = 1;
  static const int CH_STATUS_SEND = 2;

public:
  SharedMedia();
  
  virtual void xmitPacket(Packet *p);
  virtual int recvPacket(Packet *p, double *RxPr);
  
  inline double getL() {return L;}
  inline double getLambda() {return lambda;}

  virtual int command(int argc, const char*const* argv);
  virtual void dump(void) const;
  
  virtual void PowerSave(bool);
  
protected:
  double Pt;			// transmission power (W)
  double Pt_consume_;	        // power consumption for transmission (W)
  double Pr_consume_;	        // power consumption for reception (W)
  double P_idle_;               // idle power consumption (W)
  double P_sleep_;              // sleeping power consumption (W)
  double P_off_;                // off power consumption (W)
  double last_send_time_;	// the last time the node sends somthing.
  double channel_idle_time_;	// channel idle time.
  double freq;                  // frequency
  double lambda;		// wavelength (m)
  double update_energy_time_;	// the last time we update energy.
  double L;			// system loss factor
  
  double RXThresh;		// receive power threshold (W)
  double CSThresh;		// carrier sense threshold (W)
  double CPThresh;		// capture threshold (db)

  Antenna *ant;
  
  Idle_Timer idle_timer_;
  friend class Idle_Timer;

  int status_;
  
private:
  
  void UpdateIdleEnergy(double);
  
  power_t state_;
  power_mode_t power_mode_;

public:
  double idle_time;
  double sleep_time;

  inline power_t state() { return state_; }
  void set_state(power_t state);
  inline bool PowerSave() { return (power_mode_ == pwr_mode_powersave); }
  inline bool if_on() { return (state_ != pwr_state_off); }
  inline bool if_listen() { return (state_ == pwr_state_idle); }
  
};

#endif

