#!/bin/csh

unset noclobber

source $ROOT/run-setup

setenv TMPDIR	.
setenv TMPFILE	xxx

foreach i ($PT)		        # Pause Times
foreach k ($NUM_SRCS)		# Number of Sources
foreach j ($RUNS)		# Scenario File Number

setenv t1 ${XSIZE}x${YSIZE}-${NODES}-$i-${SPEED}-$j
setenv t2 cbr-${NODES}-$k-${RATE}-${PKTSIZE}

setenv out	out-${t1}-${t2}
setenv totals	totals-${t1}-${t2}
setenv fwdr	fwdr-${t1}-${t2}
setenv disc	disc-${t1}-${t2}
setenv cache	cache-${t1}-${t2}
setenv cache_summary cache_summary-${t1}-${t2}


    if($SKIP && -f $totals.rtr && -f $totals.agt) then
	echo "skiping $out --- totals files exist"
	continue
    endif


       if($NS_REMOTE_LOGS == "yes") then
	        echo "fetching ${USER}@${DEST_HOST}:${DEST_DIR}/${out}.gz"
                rcp  ${USER}@${DEST_HOST}:${DEST_DIR}/${out}.gz .
                if($status != 0) then
		       echo "Couldn't fetch $out"
		       continue
                endif
        endif


if( ! -f $OUTDIR/$out.gz) then
        echo skipping $out
        continue
else
	echo unzipping $out
endif

gunzip -c $OUTDIR/$out.gz > $TMPDIR/$TMPFILE
if ($status != 0) then
        echo ""
        echo "ERROR in gunzip..."
        echo ""
endif

#echo processing $out.mac
#totals.pl $TMPDIR/$TMPFILE MAC $NODES > $TOTDIR/$totals.mac

echo creating $totals.rtr
totals.pl $TMPDIR/$TMPFILE RTR $NODES > $TOTDIR/$totals.rtr

echo creating $totals.agt
totals.pl $TMPDIR/$TMPFILE AGT $NODES > $TOTDIR/$totals.agt

######################################################################

#echo creating $fwdr
#sample-fw-dr.pl $TMPDIR/$TMPFILE $NODES 1 > $TOTDIR/$fwdr

######################################################################
if (x$NS_PROTO == "xDSR") then
	echo creating $disc
	discovery.pl $TMPDIR/$TMPFILE $NODES  > $TOTDIR/$disc
	gzip $GZIP_OPTS $TOTDIR/$disc

	######################################################################

	echo creating $cache
	cache.pl $TMPDIR/$TMPFILE $NODES > $TOTDIR/$cache
	#
	# Take care of the "summary" file that is created automagically
	# by cache.pl
	#
	mv -f ./__tmpfile $TOTDIR/$cache_summary

	gzip $GZIP_OPTS $TOTDIR/$cache
	gzip $GZIP_OPTS $TOTDIR/$cache_summary

	######################################################################
endif

rm -f $TMPDIR/$TMPFILE

       if($NS_REMOTE_LOGS == "yes") then
                 echo "removing RDEST'd file $out.gz"
	         rm $out.gz
        endif

end
end
end
