#!/bin/csh

if( "$1" == "" ) then
	echo ""
	echo "usage: $0 <trace file>"
	echo ""
	exit 1
endif

setenv drops `grep "D " $1 | wc -l`
echo "Total Drops: $drops"

setenv drops `grep MAC $1 | grep "D " | wc -l`
echo "MAC Drops: $drops"

if($drops > 0) then
        setenv drops `grep MAC $1 | grep COL | wc -l`
        echo "     collisions: $drops"

        setenv drops `grep MAC $1 | grep RET | wc -l`
        echo "     retry count exceeded: $drops"

        setenv drops `grep MAC $1 | grep DUP | wc -l`
        echo "     duplicates: $drops"

        setenv drops `grep MAC $1 | grep BSY | wc -l`
        echo "     busy: $drops"
endif

setenv drops `grep RTR $1 | grep "D " | wc -l`
echo "Router Drops: $drops"

if($drops > 0) then

        setenv drops `grep RTR $1 | grep IFQ | wc -l`
        echo "     IFQ: $drops"

        setenv drops `grep RTR $1 | grep TOUT | wc -l`
        echo "     Timeout: $drops"

        setenv drops `grep RTR $1 | grep TTL | wc -l`
        echo "     TTL: $drops"

        setenv drops `grep RTR $1 | grep LOOP | wc -l`
        echo "     LOOP: $drops"

endif

setenv drops `grep IFQ $1 | grep -v RTR | wc -l`
echo "Interface Queue Drops: $drops"

