#!/usr/local/bin/perl

$INFILE = 0;			# input file handle

$OP_DRP = 1;
$OP_FWD = 2;

# ======================================================================
# Subroutines
# ======================================================================
sub init_samples {
	my $S = shift(@_);

	for ($i = 1; $i <= $NODES; $i++) {
		$S->[$i]->[$OP_DRP] = 0;
		$S->[$i]->[$OP_FWD] = 0;
	}
}

sub dump_samples {
	my $S = shift(@_);
	my $stime = shift(@_);

	for ($i = 1; $i <= $NODES; $i++) {
		printf("%07.3f %2d %3d %3d\n",
		       $stime, $i,
		       $SAMP->[$i]->[$OP_FWD],
		       $SAMP->[$i]->[$OP_DRP]);
	}
}

# ======================================================================
# Main Procedure
# ======================================================================
if($#ARGV != 2) {
	print stderr "\nusage: $0 <input file> <num nodes> <sampling interval>\n\n";
	exit 1;
}

if(! open $INFILE, $ARGV[0]) {
	print stderr "Could not open $ARGV[0]\n";
	exit 1;
}

$NODES = $ARGV[1];
$INTERVAL = $ARGV[2];

init_samples($SAMP);
$stime = 0.0;			# start of interval
$etime = $stime + $INTERVAL;	# end of interval
$ctime = 0.0;			# current time

while(<$INFILE>) {

	$line += 1;

	if(/^([fD]) ([0-9.]+) _(\d+)_ (RTR|IFQ)/o) {
		$op = $1;
                $ctime = $2;
                $node = $3;

		if($ctime > $etime) {
			dump_samples($SAMP, $stime);
			init_samples($SAMP);
			$stime = $etime;
			$etime = $stime + $INTERVAL;
		}

		if($node <= 0 || $node > $NODES) {
			print "invalid node number $node on line $line\n";
			exit;
		}

		if($op eq 'f') {
			$SAMP->[$node]->[$OP_FWD] += 1;
		}
		else {
			$SAMP->[$node]->[$OP_DRP] += 1;
		}
	}
	else {
		# skip this line
	}
}
