#!/bin/csh

#
# This script is simply a template that can be used to invoke the 
# run script, run.tcl.  Should you need to change its "external" behavior,
# please copy the file to your protocol directory and modify it there.
#
#                                                     - josh
#

source $ROOT/run-setup

if (! -d cmu || ! -d $SCEN_DIR || ! -d $LOG_DIR ) then
	echo ""
	echo "can't find a necessary directory (cmu, $SCEN_DIR, $LOG_DIR)."
	echo ""
	exit 1
endif

#
# ARGV
#

set skip_existing = $SKIP

if ("XX$1" == "XX-auto") then
    set SRCS = ($NUM_SRCS)
    set PAUSE = ($PT)
    set SCENS = ($RUNS)

    if ("XX$2" == "XX-skip") then
        set skip_existing = 1
    endif
else 
    if ( "$1" == "" || "$2" == "" || "$3" == "" ) then
	    echo ""
	    echo "usage: $0 <# sources> <pause time> <scenario #'s>"
	    echo "       $0 -auto"
	    echo ""
		exit 1
    endif
    set  SRCS =   $1
    set  PAUSE =  $2
    shift
    shift
    set SCENS = ($*)
endif

if (${?NS_PROTO_SCRIPT} == 0) then
        echo ""
        echo "environment variable NS_PROTO_SCRIPT is not set!"
        echo ""
        exit 1
endif

if (! -f $NS_PROTO_SCRIPT) then
        echo ""
        echo "$NS_PROTO_SCRIPT does not exist!"
        echo ""
        exit 1
endif

#
# Remote logging allows the script to be copied to a remote host.
#
if (${?NS_REMOTE_LOGS} == 0) then
        echo ""
        echo "environment variable NS_REMOTE_LOGS is not set!"
        echo ""
        exit 1
endif

# ======================================================================

foreach pause ($PAUSE)
foreach src ($SRCS)

# Comm Pattern File
setenv  CP      cbr-$NODES-$src-$RATE-$PKTSIZE

# Scenario File
setenv  SC      scen-${XSIZE}x${YSIZE}-$NODES-$pause-$SPEED

# Log File
setenv  LOG     out-${XSIZE}x${YSIZE}-$NODES-$pause-$SPEED

echo ""
echo "Simulation Parameters:"
echo "     nodes: $NODES"
echo "     time:  $TIME s"
echo "     pause: $pause s"
echo "     speed: $SPEED m/s"
echo "     size:  ${XSIZE}x${YSIZE} meters"
echo "     communication pattern: $SCEN_DIR/$CP"
echo "     scenario file base name: $SCEN_DIR/$SC"
echo "     log file base name: $LOG"
echo "     routing protocol: $NS_PROTO_SCRIPT"
echo "     remote logs: $NS_REMOTE_LOGS"
echo "            dest: ${USER}@${DEST_HOST}:${DEST_DIR}"
echo ""

if ( ! -f scen/$CP ) then
	echo ""
	echo "can't find connection script '$CP'."
	echo ""
	exit 1
endif

echo "press CTRL-C to abort..."
echo ""
sleep 5

foreach scen ($SCENS)

	setenv scenfile $SCEN_DIR/$SC-$scen
	if( -f $scenfile == 0) then
		echo ""
		echo "$scenfile does not exist"
		echo ""
		exit 1
	endif

	setenv logfile $LOG_DIR/$LOG-$scen-$CP

	if ( -f ${logfile}.gz == 1 && $skip_existing) then
	        echo ""
	        echo "skiping ns for $logfile --- already exists"
	        echo ""
		continue
	endif

	echo ""
	echo "starting ns for $logfile ..."
	echo ns cmu/scripts/run.tcl -rp $NS_PROTO_SCRIPT \
                -x $XSIZE -y $YSIZE \
                -cp $SCEN_DIR/$CP -sc $scenfile \
                -nn $NODES -stop $TIME -tr $logfile

	time ns cmu/scripts/run.tcl -rp $NS_PROTO_SCRIPT \
                -x $XSIZE -y $YSIZE \
                -cp $SCEN_DIR/$CP -sc $scenfile \
                -nn $NODES -stop $TIME -tr $logfile

	if($status != 0) then
		echo "Error: ns on $logfile"
		mv $logfile ${logfile}.BAD
		if ($CONT != 0) then
		    continue
		else
		    exit 1
		endif
	endif

	gzip $GZIP_OPTS $logfile
	if($status != 0) then
		echo ""
		echo "Error: gzip $logfile"
		echo ""
		exit 1
	endif

        if($NS_REMOTE_LOGS == "yes") then
                rcp $logfile.gz ${USER}@${DEST_HOST}:${DEST_DIR}
                if($status == 0) then
                        rm $logfile.gz
                endif
        endif

end
end
end

