#!/usr/bin/perl

#usage: make-blocks <square-length>

$sw = 0;
$w = 200;
$h = 66;



$l = $ARGV[0];
if ($ARGV[1] > 0) {
    $sw = $ARGV[1];
}
else {
    $sw = 60; # street width, metres
}

print "n 300\n";
print "t 90\n";
print "max_speed 10\n";
print "x_universe $l\n";
print "y_universe $l\n";

$curr_y = $sw;
$n = 1;
while ($curr_y < $l) {
    $curr_x = $sw;
    while ($curr_x < $l) {
	# bottom left corner of the block
	$x1 = $curr_x + $w;
	$y1 = $curr_y + $h;
	print "block$n $curr_x $curr_y $x1 $y1\n"; 
	$curr_x = $x1 + $sw;
	$n++;
    }
    $curr_y = $curr_y + $h + $sw;
}
