#!/usr/local/bin/perl

use strict 'vars';
use strict 'subs';

my $die_on_bad_format = 1;  # keep going in the face of an odd format?
my @S;
my @NAME;
my @protofunc;
my $protovalue;
my @DROP_INDEX;

my $SCRIPT_TYPE;
my $infile = 0;
my $line = 0;
my $num;
my $flag;
my $i;

# ======================================================================
# Subroutines
# ======================================================================
sub elementof {
	my $e = shift(@_);
	my $i;

	foreach $i (@_) {
		if($i eq $e) {
			return 1;
		}
	}
	return 0;
}


# ======================================================================
# Main Procedure
# ======================================================================
if($#ARGV != 1 && $#ARGV != 2  ) {
    # accept (and ignore) the third arg for compatibility with post-totals.pl
    print stderr "\nusage: $0 <input file> <AGT | RTR>\n\n";
    exit 1;
}

if($ARGV[1] ne "AGT" && $ARGV[1] ne "RTR") {
        print stderr "Invalid Script Type\n";
        exit 1;
}

$SCRIPT_TYPE = $ARGV[1];

#
# Strings to find in the totals output
#
$S[1]  = "DSR TOTALS Transmitted";
$S[2]  = "DSR TOTALS Received";
$S[3]  = "DSR TOTALS Forwards";
$S[4]  = "DSR REQUEST Transmitted";
$S[5]  = "DSR REQUEST Received";
$S[6]  = "DSR REQUEST Forwards";
$S[7]  = "DSR REQUEST Drops";
$S[8]  = "DSR REPLY Transmitted";
$S[9]  = "DSR REPLY Received";
$S[10] = "DSR REPLY Forwards";
$S[11] = "DSR REPLY Drops";
$S[12] = "DSR ERROR Transmitted";
$S[13] = "DSR ERROR Received";
$S[14] = "DSR ERROR Forwards";
$S[15] = "DSR ERROR Drops";
$S[16] = "DSR CACHED REPLY Transmitted";
$S[17] = "DSR CACHED REPLY Received";
$S[18] = "DSR CACHED REPLY Forwards";
$S[19] = "DSR CACHED REPLY Drops";
$S[20] = "DSR GRAT REPLY Transmitted";
$S[21] = "DSR GRAT REPLY Received";
$S[22] = "DSR GRAT REPLY Forwards";
$S[23] = "DSR GRAT REPLY Drops";
$S[24] = "CBR TOTALS Transmitted";
$S[25] = "CBR TOTALS Received";
$S[26] = "CBR TOTALS Drops";
$S[27] = "CBR TOTALS Overhead";
$S[28] = "Optimal Path Len on sending";
$S[29] = "Actual Path Len on receiving";
$S[30] = "Actual - Optimal Path Len on receiving";
$S[31] = "END";

#
# MATLAB Array Names
#
$NAME[1]  = "t.rtr_tx";
$NAME[2]  = "t.rtr_rx";
$NAME[3]  = "t.rtr_fw";
$NAME[4]  = "t.dsr_req_tx";
$NAME[5]  = "t.dsr_req_rx";
$NAME[6]  = "t.dsr_req_fw";
$NAME[7]  = "t.dsr_req_dr";
$NAME[8]  = "t.dsr_rep_tx";
$NAME[9]  = "t.dsr_rep_rx";
$NAME[10] = "t.dsr_rep_fw";
$NAME[11] = "t.dsr_rep_dr";
$NAME[12] = "t.dsr_err_tx";
$NAME[13] = "t.dsr_err_rx";
$NAME[14] = "t.dsr_err_fw";
$NAME[15] = "t.dsr_err_dr";
$NAME[16] = "t.dsr_crep_tx";
$NAME[17] = "t.dsr_crep_rx";
$NAME[18] = "t.dsr_crep_fw";
$NAME[19] = "t.dsr_crep_dr";
$NAME[20] = "t.dsr_grep_tx";
$NAME[21] = "t.dsr_grep_rx";
$NAME[22] = "t.dsr_grep_fw";
$NAME[23] = "t.dsr_grep_dr";
$NAME[24] = "t.cbr_tx";
$NAME[25] = "t.cbr_rx";
$NAME[26] = "t.cbr_dr";
$NAME[27] = "t.cbr_ov";
$NAME[28] = "t.opt";
$NAME[29] = "t.act";
$NAME[30] = "t.dif";

@DROP_INDEX = ("7", "11", "15", "19", "23");

#
# Protocol Functions
#
@protofunc = ("send buffer drops",
		"new route requests",
		"replies sent by target",
		"replies sent from cache",
		"replies received",
		"grat replies",
		"packets salvaged",
		"packets not salvaged",
		"bad replies not salvaged",
		"IFQ len above 25");

# ======================================================================
#
# Identifing Comment
#
print "%\n% Script $ARGV[0], $ARGV[1], $ARGV[2]\n%\n";

$num = 1;               # index into S[]

START_READING_FILE:

if(! open $infile, $ARGV[0]) {
        print stderr "Could not open $ARGV[0]\n";
        exit 1;
    }

while(<$infile>) {

        if($S[$num] eq "END") {
                goto FINISHED_PART1;                           # DONE
        }

	$line += 1;

	############################################################

	if(/^\s+(.*): (\d+)/o) {
		if(elementof($1, @protofunc)) {
			$protovalue->{$1} = $2;
			next;
		}
	}

	############################################################

        if($flag == 1) {

                if(/^\s+Packets:\s+(\d+)/o) {
                        print "$1 ";
                }
                elsif(/^\s+Bytes:\s+(\d+)/o) {
			print "$1 ";
			if($SCRIPT_TYPE eq "AGT" || 
		           elementof($num, @DROP_INDEX) == 0) {
				print "\];\n";
				$flag = 0;
				$num += 1;
			}
                }

		elsif(elementof($num, @DROP_INDEX)) {

			#
			# CBR MAC Drops
			#
			if(/^\s+Collision:\s+(\d+)/o) {
				print "$1 ";
			}
			elsif(/^\s+Duplicate:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+CRC Invalid:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Max Retries:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Invalid State:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Busy:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
			}

			#
			# CBR RTR Drops
			#
			elsif(/^\s+No Route:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+TTL Expired:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+RTR Queue Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Timeout:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Routing Loop:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+IFQ Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+ARP Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Callback:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+SIM End:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
			}
			else {
		    		print "\];\n";
		    		$flag = 0;
		    		$num += 1;
			}
		}
		#
		# CBR Summary Information
		#
                elsif(/^\s+Optimal Len Sum:\s+(\d+)/o) {
                        print "$1 \];\n";
                        $flag = 0;
                        $num += 1;
                }
                elsif(/^\s+Optimal Len.*:\s+(\d+)/o) {
                        print "$1 ";
                }

                elsif(/^\s+Actual Len Sum:\s+(\d+)/o) {
                        print "$1 \];\n";
                        $flag = 0;
                        $num += 1;
                }
                elsif(/^\s+Actual Len.*:\s+(\d+)/o) {
                        print "$1 ";
                }

                elsif(/^\s+Actual - Optimal Len Sum:\s+(\d+)/o) {
                        print "$1 \];\n";
                        $flag = 0;
                        $num += 1;
                }
                elsif(/^\s+Actual - Optimal Len.*:\s+(\d+)/o) {
                        print "$1 ";
                }
                
                next;
       }

        if(/^\s+$S[$num]/) {
                $flag = 1;
                print "$NAME[$num] = \[ ";
        }
}

# hmmm, we ran off the end of the file without finding all the tags
# we were looking for...
print stderr "\nDidn't find tag '$S[$num]'\n";
print stderr "  in $ARGV[0] --- old format totals file?\n";

if ($die_on_bad_format) {
    exit -1;
} else {
    # just skip over the tag we couldn't find and try again
    $num++;
    goto START_READING_FILE;
}


FINISHED_PART1:

#
# Dump the protovalue array
#
print "t.dsr_proto = [ ";
foreach $i (@protofunc) {
	if($protovalue->{$i} eq "") {
		print stderr "protocol functions ERROR: $i\n";
		if ($die_on_bad_format) {
		    exit 1;
		} else {
		    print "0 ";
		}
	}
	print "$protovalue->{$i} ";
}
print " ];\n";

# ======================================================================

my @T;
my @N;
my $node;
my $maxnum;

sub init_t {
        $T[1] = "CBR TOTALS ${node} Transmitted";
        $T[2] = "CBR TOTALS ${node} Received";
        $T[3] = "CBR TOTALS ${node} Forwards";
        $T[4] = "CBR TOTALS ${node} Drops";
}

sub init_n {
        $N[1] = "t.cbr_tx_${node}";
        $N[2] = "t.cbr_rx_${node}";
        $N[3] = "t.cbr_fw_${node}";
        $N[4] = "t.cbr_dr_${node}";
}

$flag = 0;
$node = 1;
$num = 1;
$maxnum = 5;

init_t();
init_n();

while(<$infile>) {

        if($num == $maxnum) {
                $num = 1;               # the next node
        }

	$line += 1;

        if($flag == 1) {

                if(/^\s+Packets:\s+(\d+)/o) {
                        print "$1 ";
                }
                elsif(/^\s+Bytes:\s+(\d+)/o) {
			print "$1 ";
			if($num != 4) {
				print "\];\n";
				$flag = 0;
				$num += 1;
			}
                }

		#
		# CBR MAC Drops
		#
		elsif($num == 4) {

			if(/^\s+Collision:\s+(\d+)/o) {
				print "$1 ";
			}
			elsif(/^\s+Duplicate:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+CRC Invalid:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Max Retries:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Invalid State:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Busy:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
			}

			#
			# CBR RTR Drops
			#
			elsif(/^\s+No Route:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+TTL Expired:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+RTR Queue Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Timeout:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+Routing Loop:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+ARP Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+IFQ Full:\s+(\d+)/o) {
		    		print "$1 ";
			}
			elsif(/^\s+MAC Callback:\s+(\d+)/o) {
		    		print "$1 \];\n";
		    		$flag = 0;
		    		$num += 1;
                                $node += 1;
                                init_t();
                                init_n();
			}
			else {
                                print stderr "Input Error in line $line\n$_\n";
				if ($die_on_bad_format) {
				    exit 1;
				} else {
				    print stderr "";
				}
			}
		}
                next;
        }

        if(/^\s+$T[$num]/) {
                $flag = 1;
                print "$N[$num] = \[ ";
        }
}

