#!/usr/local/bin/perl

use strict vars;

#
# The events that I'm looking for...
#
my $TX_RING0_REQUEST = 0x01;
my $TX_PROP_REQUEST = 0x02;
my $FW_REQUEST = 0x04;
my $RX_REQUEST = 0x08;
my $RX_REPLY = 0x10;
my $RX_REPLY_CACHED = 0x11;
my $RX_REPLY_GRAT = 0x12;
my $infile = 0;
my $RR;
my $MAX_NODES;
my $line;
my $hdr;

# ======================================================================
# Subroutines
# ======================================================================
sub numerically { $a <=> $b; }

sub process_dsr {
        my $hdr = shift(@_);
        my $LINE = shift(@_);              # line from log file

        my $OP = $hdr->{opcode};
	my $TIME = $hdr->{time};
	my $NODE = $hdr->{node};

	if($LINE =~ / ------- \[(\d+):\d+ \d+:\d+ \d+ \d+\] (\d+) \[(\d+) (\d+) (\d+)\] \[(\d+) (\d+) \d+ (\d+)->(\d+)\]/o) {
		my $src_ipaddr = $1;
#		my $src_port = $;
#		my $dst_ipaddr = $;
#		my $dst_port = $;
#               my $ip_ttl = $;
#               my $ip_nexthop = $;
		my $dsr_numaddrs = $2;
		my $pkt_req = $3;
		my $pkt_req_seqno = $4;
		my $pkt_req_maxprop = $5;
		my $pkt_rep = $6;
		my $pkt_rep_seqno = $7;
#		my $pkt_rep_len = $;
		my $pkt_rep_src = $8;
		my $pkt_rep_dst = $9;

		#
		# Track Route Request originations / forwards
		#
		if($pkt_req && ($OP eq 's' || $OP eq 'f')) {
			if($OP eq 's') {
				if($pkt_req_maxprop == 0) {
					$RR->[$src_ipaddr]->{$TIME}->{"op"} =
					    $TX_RING0_REQUEST;
				}
				else {
					$RR->[$src_ipaddr]->{$TIME}->{"op"} =
					    $TX_PROP_REQUEST;
				}
			}
			elsif($OP eq 'f') {
				$RR->[$src_ipaddr]->{$TIME}->{"op"} = $FW_REQUEST;
			}
			$RR->[$src_ipaddr]->{$TIME}->{"seqno"} = $pkt_req_seqno;
			$RR->[$src_ipaddr]->{$TIME}->{"forwards"} =
			    $dsr_numaddrs - 1;
		}
		#
		# We care about when Route Replies are received by the
		# originator of a Request.
		#
		elsif($pkt_rep && $OP eq 'r' && $NODE == $pkt_rep_src) {
			if($pkt_rep_seqno == 0) {
				$RR->[$NODE]->{$TIME}->{"op"} = $RX_REPLY_GRAT;
			}
			elsif($pkt_rep_dst != $src_ipaddr) {
				$RR->[$NODE]->{$TIME}->{"op"} = $RX_REPLY_CACHED;
			}
			else {
				$RR->[$NODE]->{$TIME}->{"op"} = $RX_REPLY;
			}
			$RR->[$NODE]->{$TIME}->{"seqno"} = $pkt_rep_seqno;
			$RR->[$NODE]->{$TIME}->{"forwards"} = $dsr_numaddrs - 1;
		}
		#
		# We also want to measure the number of intermediate nodes
		# that receive a request.
		#
		elsif($pkt_req && $OP eq 'r') {
		    $RR->[$NODE]->{$TIME}->{"op"} = $RX_REQUEST;
		    $RR->[$NODE]->{$TIME}->{"seqno"} = $pkt_rep_seqno;
		    $RR->[$NODE]->{$TIME}->{"forwards"} = $dsr_numaddrs - 1;
		}
		else {
			# don't care about these...
		}
	}
	else {
		print stderr "DSR Logging error\n$LINE\n";
		exit 1;
	}
}


sub dump_dsr {
        my $n;
        my $i;

	print "%\n";
        print "% 1: time\n";
        print "% 2: node\n";
        print "% 3: sequence\n";
        print "% 4: operation\n";
	print "%\tRing 0 Route Request Transmit $TX_RING0_REQUEST\n";
	print "%\tProp Route Request Transmit $TX_PROP_REQUEST\n";
	print "%\tRoute Request Forward  $FW_REQUEST\n";
	print "%\tRoute Reply            $RX_REPLY\n";
	print "%\tRoute Reply (Cached)   $RX_REPLY_CACHED\n";
	print "%\tRoute Reply (Grat)     $RX_REPLY_GRAT\n";
        print "% 5: forwards\n";
        print "% 6: good\n";
	print "%\n";

	for($n = 1; $n <= $MAX_NODES; $n++) {
		my @tkey = sort numerically keys %{$RR->[$n]};
		foreach $i (@tkey) {
			printf("%14.9f %3d %3d %3d %3d %3d\n",
			       $i, $n,
			       $RR->[$n]->{$i}->{"seqno"},
			       $RR->[$n]->{$i}->{"op"},
			       $RR->[$n]->{$i}->{"forwards"},
			       $RR->[$n]->{$i}->{"good"} ? 
			       $RR->[$n]->{$i}->{"good"} : 0); 
#			}
		}
	}
}

# ======================================================================
# Main Procedure
# ======================================================================
$infile = 0;

if($#ARGV != 1) {
	print stderr "\nusage: $0 <input file> <num nodes>\n\n";
	exit 1;
}

if(! open $infile, $ARGV[0]) {
	print stderr "Could not open $ARGV[0]\n";
	exit 1;
}

$MAX_NODES = $ARGV[1];

while(<$infile>) {

	$line += 1;

	if(/^([frs]) ([0-9.]+) _(\d+)_ RTR .* DSR/o) {
		$hdr->{opcode} = $1;
                $hdr->{time} = $2;
                $hdr->{node} = $3;

		if($hdr->{node} > $MAX_NODES) {
			print stderr "Invalid node number $hdr->{node}\n";
			print stderr "$_";
			exit 1;
		}
		process_dsr($hdr, $_);
	}
	# SRR 23.621698113 _47_ reply-received 1 from 38  47 #6 
	elsif(/^SRR ([0-9.]+) _(\d+)_ reply-received (\d+) from \d+  (\d+) \#(\d+)/o) {
		$hdr->{opcode} = 'r';
		$hdr->{time} = $1;
		$hdr->{node} = $2;

		if($2 != $4) {
			print stderr "Invalid node number\n";
			print stderr "$_";
			exit 1;
		}
		$RR->[$hdr->{node}]->{$hdr->{time}}->{"good"} = $3;
	}
	else {
		# do nothing
	}
}

dump_dsr();
