#!/usr/local/bin/perl


$POSSIIBLE = 1;
$RCVD = 2;
$TIME  = 3;
$MACSRC = 4;
$MACID = 5;

$max_uid = -1;
$bc_send = 0;

sub find_index {
    my ($macid, $macsrc) = @_;
    my $c;

    for ($c = $bc_send; c >= 0 ; $c--)
    {
	if ($pkts[$c]->[$MACSRC] == $macsrc && $pkts[$c]->[$MACID] == $macid)
	{ return $c; }
    }
    printf("dfu: no such packet $bc_send $macid $macsrc\n");
}


while(<>) {

    if(/^([rsfD]) (\d+\.\d+) _(\d+)_ (\S+)\s+(\S+) (\d+) (\S+) (\d+) \[(\w+) \w+ (\w+) (\w+) (\w+) \w+\]/o) {
	$optype =  $1;
	$time = $2;
	$hdr->{node} = $3;
	$hdr->{logtype} = $4;           # AGT, RTR, MAC
	$hdr->{logreason} = $5;
	$hdr->{uid} = $6;
	$hdr->{pkttype} = $7;
	$hdr->{pktsize} = $8;
	$hdr->{mactype} = hex($9);
	$hdr->{macdest} = hex($10);
	$hdr->{macsrc} = hex($11);
	$hdr->{macid} = hex($12);

	if ($hdr->{logtype} ne "MAC" || $hdr->{mactype} != 0x20 
	    || $hdr->{macdest} != 0xffffffff) { next; }
	
	if ($max_uid < $hdr->{uid}) {$max_uid = $hdr->{uid};}

	if ($optype eq "s") {	    
	    $pkts[$bc_send]->[$TIME] = $time;
	    $pkts[$bc_send]->[$POSSIBLE] = 0;
	    $pkts[$bc_send]->[$RCVD] = 0;
	    $pkts[$bc_send]->[$MACSRC] = $hdr->{macsrc};
	    $pkts[$bc_send]->[$MACID] = $hdr->{macid};
	    $bc_send++;
	} elsif ($optype eq "r") {
	    $i = find_index($hdr->{macid}, $hdr->{macsrc});
	    $pkts[$i]->[$POSSIBLE] += 1;
	    $pkts[$i]->[$RCVD] += 1;
	} elsif ($optype eq "D" && $hdr->{logreason} eq "COL") {
	    $i = find_index($hdr->{macid}, $hdr->{macsrc});
	    $pkts[$i]->[$POSSIBLE] += 1;
	} else {
	    printf("wierdness: $_\n");
	}	 
    }
}
$pkts[0]->[$TIME] = 0;

for ($c = 0; $c <= $bc_send ; $c++)
{
    if ($pkts[$c]->[$TIME] != 0)
    {
	printf("%f\t%d\t%d\n",$pkts[$c]->[$TIME], $pkts[$c]->[$POSSIBLE],
	       $pkts[$c]->[$RCVD]);
    }
}
