#!/usr/local/bin/perl

use English;

$default_conn_filename = 'ntr-conn';

if ($#ARGV == 1) {
	$src = shift;
	$dst = shift;
	$CP = $default_conn_filename;
} elsif ($#ARGV == 2) {
	$CP = shift;
	$src = shift;
	$dst = shift;	
} else {
	die "usage: add-ntrwkld.pl [connection file] src dst\n";
}

open(F,">>$CP") or die "Can't write to connection pattern file $CP\n";

print F <<"HERE"

#
# Create NTR workload source pinging node dst from src
#
Agent/NTRWKLD set interval_ 0.2        ;# time between tests
Agent/NTRWKLD set maxTests_ -1         ;# num tests, -1 means infinity
Agent/NTRWKLD set bigPacketSize_ 1000
Agent/NTRWKLD set smallPacketSize_ 4
Agent/NTRWKLD set sport_ 0
Agent/NTRWKLD set dport_ 0

set src [new Agent/NTRWKLD]
set dst [new Agent/NTRWKLD]

\$ns_ attach-agent \$node_($src) \$src
\$ns_ attach-agent \$node_($dst) \$dst

set T [new Trace/Generic]
\$T target [\$ns_ set nullAgent_]
\$T attach \$tracefd
\$src log-target \$T
\$dst log-target \$T

\$ns_ connect \$src \$dst

\$ns_ at 0.0 "\$src start"

HERE
