#include <cmu/rttable.h>

/* =====================================================================
   The Routing Table
   ===================================================================== */

rt_entry::rt_entry()
{
        rt_dst = 0;
        rt_seqno = 0;
        rt_nexthop = 0;
        rt_expire = 0.0;
        rt_hops = 0;
        rt_flags = 0;

        rt_errors = 0;
        rt_error_time = 0.0;

        rt_req_timeout = 0.0;
        rt_req_cnt = 0;

        LIST_INIT(&rt_nblist);
};


rt_entry::~rt_entry()
{
        Neighbor *nb;

        while((nb = rt_nblist.lh_first)) {
                LIST_REMOVE(nb, nb_link);
                delete nb;
        }
}


void
rt_entry::nb_insert(nsaddr_t id)
{
        Neighbor *nb = new Neighbor(id);
        assert(nb);

        nb->nb_expire = 0;
        LIST_INSERT_HEAD(&rt_nblist, nb, nb_link);
}


Neighbor*
rt_entry::nb_lookup(nsaddr_t id)
{
        Neighbor *nb = rt_nblist.lh_first;

        for(; nb; nb = nb->nb_link.le_next) {
                if(nb->nb_addr == id)
                        break;
        }
        return nb;
}

/* =====================================================================
   The Routing Table
   ===================================================================== */
rt_entry*
rttable::rt_lookup(nsaddr_t id)
{
        rt_entry *rt = rthead.lh_first;

        for(; rt; rt = rt->rt_link.le_next) {
                if(rt->rt_dst == id)
                        break;
        }
        return rt;
}

void
rttable::rt_delete(nsaddr_t id)
{
        rt_entry *rt = rt_lookup(id);

        if(rt) {
                LIST_REMOVE(rt, rt_link);
                delete rt;
        }
}

rt_entry*
rttable::rt_add(nsaddr_t id)
{
        rt_entry *rt;

        assert(rt_lookup(id) == 0);

        rt = new rt_entry;
        assert(rt);

        rt->rt_dst = id;
        LIST_INSERT_HEAD(&rthead, rt, rt_link);

        return rt;
}
