/* -*- c++ -*-
 * Copyright (c) 1993-1997 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the Computer Systems
 *	Engineering Group at Lawrence Berkeley Laboratory.
 * 4. Neither the name of the University nor of the Laboratory may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: /home/cr1/benjie/cvsroot/ns/ns-span/cmu/ntr-workload.h,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $ (LBL)
 */

#ifndef ns_emulate_ntr_workload_h
#define ns_emulate_ntr_workload_h

#include <stdarg.h>

#include <packet.h>
#include <agent.h>
#include <trace.h>

class NTRWKLD_Agent;

class NTRWKLD_Timer : public TimerHandler {
public:
	NTRWKLD_Timer(NTRWKLD_Agent *a) : TimerHandler() { a_ = a; }
protected:
	virtual void expire(Event *e);
	NTRWKLD_Agent *a_;
};

// carried in data_ of packet --- basically an ICMP echo request/reply
struct ping_data {
  int type;
#define ECHO_REQUEST 1
#define ECHO_REPLY 2
  u_int32_t seqno;
  double timestamp;
};

class NTRWKLD_Agent : public Agent {
 public:
	NTRWKLD_Agent();
	int command(int argc, const char*const* argv);
	virtual void timeout(int);
	virtual void recv(Packet* p, Handler*);
 protected:
	void start();
	void stop();
	void sendRequest(int size);
	void logReply(Packet *p);
	void logRequest(Packet *p);
	void reflect(Packet *p);
	void trace(char* fmt, ...);

	int running_;
	int maxTests_;
	int testNumber_;
	double interval_;
	int seqno_;
	int bigPacketSize_;
	int smallPacketSize_;
        int off_ip_;

	Trace *logtarget_;
	NTRWKLD_Timer timer_;
};

#endif ns_emulate_ntr_workload_h
