#include <nort/nort.h>
#include <ip.h>
#define CURRENT_TIME    Scheduler::instance().clock()

/* ======================================================================
   TCL Hooks
   ====================================================================== */
static class NORTclass : public TclClass {
public:
        NORTclass() : TclClass("Agent/rtProto/NORT") {}
        TclObject* create(int argc, const char*const* argv) {
                assert(argc == 5);
                return (new NORT((nsaddr_t) atoi(argv[4])));
        }
} class_rtProtoNORT;



/* ===================================================================== */

/* ===================================================================== */

NORT::NORT(nsaddr_t id) : Agent(PT_NTYPE)
{
        index = id;
}

int
NORT::command(int argc, const char*const* argv)
{
        if(argc == 2) {
                Tcl& tcl = Tcl::instance();

                if(strncasecmp(argv[1], "id", 2) == 0) {
                        tcl.resultf("%d", index);
                        return TCL_OK;
                }
                if(strncasecmp(argv[1], "start", 2) == 0) {
			return TCL_OK;
                }               
        }
        else if(argc == 3) {

                if(strcmp(argv[1], "index") == 0) {
                        index = atoi(argv[2]);
                        return TCL_OK;
                }
                else if(strcmp(argv[1], "log-target") == 0) {
                        return TCL_OK;
                }
                else if(strcmp(argv[1], "drop-target") == 0) {
			return TCL_OK;
                }
                else if(strcmp(argv[1], "if-queue") == 0) {
                        return TCL_OK;
                }
        }
        return Agent::command(argc, argv);
}

void
NORT::recv(Packet *p, Handler*)
{

#if 0
  /* when things are really screwed up, just turn off arp and
     blast the packets to broadcast MAC addr */
  //bind("off_ip_", &off_ip_);
  struct hdr_ip *ip = (hdr_ip*)p->access(off_ip_);

  struct hdr_cmn *cmh = HDR_CMN(p);

  // by setting the next_hop_ to ip->dst() the packet gets the proper destination address
  // w/o needing arp (so all nodes don't receive the packet...other wise use next_hop_ =
  // 0xffffffff to send the packet to all nodes...

  cmh->next_hop_ = ip->dst();
  //  cmh->next_hop_ = 0xffffffff;
  cmh->addr_type_ = AF_LINK;

#endif
  struct hdr_ip *ip = (hdr_ip*)p->access(off_ip_);
  struct hdr_cmn *cmh = HDR_CMN(p);
  cmh->next_hop_ = ip->dst();
  cmh->addr_type_ = AF_INET;
  target_->recv(p, (Handler*) 0);
}

