/* -*- c++ -*- */
#ifndef __node_h__
#define __node_h__

#define POSITION_UPDATE_INTERVAL	30.0	// seconds
#define MAX_SPEED			5.0	// meters per second (33.55 mph)
#define MIN_SPEED			0.0

#include <object.h>
#include <trace.h>
#include <cmu/net-if.h>
#include <cmu/topography.h>
#include <cmu/energy-model.h>
#include <cmu/arp.h>
#include <cmu/quadtree.h>
#include <cmu/energy-model.h>
#include <cmu/god.h>

class GridAgent;
class MobileNode;

#if COMMENT_ONLY
		 -----------------------
		|			|
		|	Upper Layers	|
		|			|
		 -----------------------
		    |		    |
		    |		    |
		 -------	 -------
		|	|	|	|
		|  LL	|	|  LL	|
		|	|	|	|
		 -------	 -------
		    |		    |
		    |		    |
		 -------	 -------
		|	|	|	|
		| Queue	|	| Queue	|
		|	|	|	|
		 -------	 -------
		    |		    |
		    |		    |
		 -------	 -------
		|	|	|	|
		|  Mac	|	|  Mac	|
		|	|	|	|
		 -------	 -------
		    |		    |
		    |		    |
		 -------	 -------	 -----------------------
		|	|	|	|	|			|
		| Netif	| <---	| Netif | <---	|	Mobile Node	|
		|	|	|	|	|			|
		 -------	 -------	 -----------------------
		    |		    |
		    |		    |
		 -----------------------
		|			|
		|	Channel(s) 	|
		|			|
		 -----------------------
#endif

class PositionHandler : public Handler {
public:
	PositionHandler(MobileNode* n) : node(n) {}
	void handle(Event*);
private:
	MobileNode *node;
};


/* ======================================================================
   Mobile Node

	A mobile node is designed for the purposes of being able to
	represent true mobility.
   ====================================================================== */

class MobileNode : public TclObject {

	friend class PositionHandler;

public:
	MobileNode();
	virtual int command(int argc, const char*const* argv);

	EnergyModel *energy_model() const { return energy_model_; }
        void PowerSave(int i, bool on);
        void dump_time();

	double	distance(MobileNode*);
	double	propdelay(MobileNode*);
	void	start(void);
        inline void getLoc(double *x, double *y, double *z) {
	  update_position();  *x = X; *y = Y; *z = Z;
	}
        inline void getVelo(double *dx, double *dy, double *dz) {
	  *dx = dX * speed; *dy = dY * speed; *dz = 0.0;
	  // XXX should calculate this for real based on current 
	  // and last Z position
	}
       
	//Jinyang: I hack whatever I like hahahah..
	inline double getSpeed() {
	    return speed;
	}

        inline Trace *log_target() { return log_target_; }
    
	inline int index() { return index_; }
	inline MobileNode* nextnode() { return link.le_next; }

        inline EnergyModel *energy_model() {
	    return energy_model_;
	}

        void log_energy(int);
        void log_energy(double energy);

	void dump(void);
        /*
	 * The topography over which the mobile node moves.
	 */
	Topography *T;
	int		index_;		// unique identifier
        unsigned int loc_seq_no_; // decouto 18 nov 2000

#ifdef IDEAL_ROUTE
	Quadtree *mytree;
	Quadtree *root;
	qtree_node *node;
#endif

#define GRID_USE_ONLY 1
#if GRID_USE_ONLY
  /* this emulates a location service.  it is up to each node to
     initialize its have_advertised_loc flag.  the node should set the
     flag when putting a location in here.  it is possible that nodes
     may stop advertising their location -- they can withdraw their
     location */
        double advertised_x;
        double advertised_y;
        bool have_advertised_loc;
        double last_advertised_jiff;
        GridAgent *grid_agent;
#endif

    static MobileNode* get_node_by_address (nsaddr_t id);

protected:
	// Used to generate position updates
	PositionHandler pos_handle;
	Event pos_intr;

	void	log_movement();
	void	update_position();
	void	random_direction();
	void	random_speed();
        void    random_destination();
        int	set_destination(double x, double y, double speed);
	  
	/*
	 * Last time the position of this node was updated.
	 */
	double position_update_time;
        double position_update_interval;

	/*
         *  The following indicate the (x,y,z) position of the node on
         *  the "terrain" of the simulation.
         */
	double X;
	double Y;
	double Z;

	double speed;	// meters per second

private:
	inline int initialized() {
		return (T && log_target_ &&
			X >= T->lowerX() && X <= T->upperX() &&
			Y >= T->lowerY() && Y <= T->upperY());
	}
	void		random_position();
	void		bound_position();

	int		random_motion_;	// is mobile

	/*
	 * A global list of mobile nodes
	 */
	LIST_ENTRY(MobileNode)	link;

	/*
	 *  A list of network interfaces associated with this
	 *  mobile node.  Each interface is in turn connected
	 *  to a channel  There may be one or more channels.
	 */
	struct if_head	ifhead;

	/*
         *  The following is a unit vector that specifies the
         *  direction of the mobile node.  It is used to update
         *  position
         */
	double dX;
	double dY;
	double dZ;

        /* where are we going? */
	double destX;
	double destY;

protected:
    EnergyModel* energy_model_;
    bool pwr_mgt_;

private:
	/*
	 * Trace Target
	 */
	Trace *log_target_;
};

#endif /* __node_h__ */

