
/* -*- c++ -*- 
   $Id: mac.h,v 1.1.1.1 2001/11/15 19:43:16 benjie Exp $
*/
#ifndef __mac_h__
#define __mac_h__

#include <assert.h>
#include <connector.h>
#include <packet.h>

#include <cmu/energy-model.h>
#include <cmu/ll.h>
#include <cmu/net-if.h>
#include <cmu/marshall.h>

//class Mac;

typedef u_int32_t MacAddr;

/* ======================================================================
   Defines / Macros used by all MACs.
   ====================================================================== */
#define ETHER_ADDR(x)	((MacAddr)GET4BYTE(x))

#define MAC_HDR_LEN	      64
#define MAC_BROADCAST	      ((u_int32_t) 0xffffffff)

#define ETHER_MAC_PREAM_LEN   1
#define ETHER_SFD_LEN         1
#define ETHER_ADDR_LEN	      6 
#define ETHER_TYPE_LEN        2
#define ETHER_FCS_LEN         4

#define ETHERTYPE_IP	0x0800
#define ETHERTYPE_ARP	0x0806

enum MacState {
	MAC_IDLE	= 0x0000,
	MAC_POLLING	= 0x0001,
	MAC_RECV 	= 0x0010,
	MAC_SEND 	= 0x0100,
	MAC_RTS		= 0x0200,
	MAC_CTS		= 0x0400,
	MAC_ACK		= 0x0800,
	MAC_COLL	= 0x1000,
	MAC_BEACON      = 0x2000,
	MAC_ATIM        = 0x4000
};

/* ======================================================================
   This packet header is just a place holder.  The real headers are
   defined by their respective MAC protocols.
   ====================================================================== */
struct hdr_mac {
	static int	offset_;
};

/* ======================================================================
   Objects that want to promiscously listen to the packets before
   address filtering must inherit from class Tap in order to plug into
   the tap
   ====================================================================== */
class Tap {
public:
  virtual void tap(const Packet *p) = 0;
  // tap is given all packets received by the host.
  // it must not alter or free the pkt.  If you want to frob it, copy it.
};

/* ======================================================================
   MAC data structure
   ====================================================================== */
class Mac : public Connector {
public:
	Mac();
	inline u_int32_t	address() { return index; }
	virtual void		recv(Packet* p, Handler* h) = 0;
	virtual inline MacAddr	hdr_dst(void* hdr, MacAddr dst = 0) = 0;
	virtual inline MacAddr	hdr_src(void* hdr, MacAddr src = 0) = 0;
	virtual inline int	hdr_type(void* hdr, u_int16_t type = 0) = 0;
        virtual void            installTap(Tap *t) { tap = t; }
	virtual void		sleep() {asleep = true;}
	virtual void		wakeup() {asleep = false;}

//private: jinyang made all public
	virtual void		discard(Packet *p, const char* why = 0) = 0;
	virtual void		send(Packet *p, Handler *h) = 0;

//protected: jinyang made all public
	virtual int		command(int argc, const char*const* argv);
	virtual int initialized() {
		return (logtarget_ && netif_ && recvtarget_ && sendtarget_);
	}

	void mac_log(Packet *p) {
		logtarget_->recv(p, (Handler*) 0);
	}
	void init() { asleep = false; return;}

	u_int32_t		index;		// MAC Address

        int		off_mac_;	// MAC header offset

	NsObject	*recvtarget_;
	NsObject	*sendtarget_;
	NetIf		*netif_;
        NsObject        *logtarget_;
	EnergyModel	*energy_model_;
	MobileNode	*node_;

        Tap             *tap;

	LL		*ll_;
	Handler		*upcall_;	// callback for end-of-transmission

	bool		asleep;		//added by Jinyang: put the Mac to Sleep
	/* ============================================================
	   Internal MAC State
	   ============================================================ */
	MacState	state;		// MAC's current state

	Packet		*pktRx;
	Packet		*pktTx;
};

#endif /* __mac_h__ */
