#include <delay.h>
#include <connector.h>
#include <packet.h>
#include <random.h>

// #define DEBUG
#include <cmu/god.h>
#include <debug.h>
#include <arp.h>
#include <ll.h> 
#include <mac.h>

/* ======================================================================
   Mac Packet Header
   ====================================================================== */
int hdr_mac::offset_;

static class MacHeaderClass : public PacketHeaderClass {
public:
	MacHeaderClass() :
		PacketHeaderClass("PacketHeader/Mac", MAC_HDR_LEN) {
		offset(&hdr_mac::offset_);
	}
} class_machdr;


/* ======================================================================
   Mac Class Functions
   ====================================================================== */
static int MacIndex = 1;

Mac::Mac() : Connector()
{
        index = MacIndex++;
        bind("off_mac_", &off_mac_);

	recvtarget_ = 0;
	sendtarget_ = 0;
        netif_ = 0;
	ll_ = 0;
        upcall_ = 0;

        state = MAC_IDLE;
        pktTx = 0;
        pktRx = 0;
	tap = 0;

	//added by jinyang
	God::instance()->maclist[index] = this;
}

int
Mac::command(int argc, const char*const* argv)
{
	if(argc == 2) {
		Tcl& tcl = Tcl::instance();

		if(strcmp(argv[1], "recvtarget") == 0) {
			tcl.resultf("%s", recvtarget_->name());
			return TCL_OK;
		}
		if(strcmp(argv[1], "sendtarget") == 0) {
			tcl.resultf("%s", sendtarget_->name());
			return TCL_OK;
		} else if(strcasecmp(argv[1], "initialize") == 0) {
		        init();
			return TCL_OK;
		}
		else if(strcasecmp(argv[1], "id") == 0) {
		  tcl.resultf("%d", address());
		  return TCL_OK;
		}
	}
	if (argc == 3) {
		TclObject *obj;

		obj = TclObject::lookup(argv[2]);
		if (0 == obj) {
			fprintf(stderr, "%s lookup failed\n", argv[1]);
			return TCL_ERROR;
		}

		if (strcmp(argv[1], "recvtarget") == 0) {
			recvtarget_ = (NsObject*) obj;
			return TCL_OK;
		}
		if (strcmp(argv[1], "sendtarget") == 0) {
			sendtarget_ = (NsObject*) obj;
			return TCL_OK;
		}
		if (strcmp(argv[1], "netif") == 0) {
			netif_ = (NetIf*) obj;
			return TCL_OK;
		}
		if (strcmp(argv[1], "log-target") == 0) {
			logtarget_ = (NsObject*) obj;
			return TCL_OK;
		}


	}
	return Connector::command(argc, argv);
}

